// This program demonstrates the proper way to create a modal
// dialog from scratch.
//
// Note, that you must connect to the button clicked event and 
// not any of the button events.  Connecting to the button events
// means the dialog will be launched in an event loop and Gtk::Main::run
// won't function properly.
//
#include <gtkmm.h>
#include <string>
#include <iostream>

//TODO: Use new Dialog::run() feature instead of this hack.

using SigC::slot;

class MyDialog: public Gtk::Window
{
public:
  MyDialog(const Glib::ustring &label);
  virtual ~MyDialog();

  Glib::ustring run();

protected:
  bool canceled;
  void okay();
  void cancel();
  bool key(GdkEventKey* key);

  Gtk::Entry* entry;
};

MyDialog::MyDialog(const Glib::ustring &l)
  : canceled(false)
  {
    set_modal(true);

    entry = manage(new Gtk::Entry);
    entry->signal_key_press_event().connect(slot(*this, &MyDialog::key));

    Gtk::Button *okay_b = manage(new Gtk::Button("Okay"));
    Gtk::Button *cancel_b = manage(new Gtk::Button("Cancel"));
    okay_b->signal_clicked().connect(slot(*this, &MyDialog::okay));
    cancel_b->signal_clicked().connect(slot(*this, &MyDialog::cancel));

    Gtk::Box *box2 = manage(new Gtk::HBox());
    box2->pack_start(*okay_b, Gtk::PACK_SHRINK, 10);
    box2->pack_end(*cancel_b, Gtk::PACK_SHRINK, 10);

    Gtk::Box *box = manage(new Gtk::VBox());
    box->pack_start(*manage(new Gtk::Label(l)), Gtk::PACK_EXPAND_WIDGET, 10);
    box->pack_start(*entry, Gtk::PACK_EXPAND_WIDGET ,10);
    box->pack_start(*box2, Gtk::PACK_EXPAND_WIDGET ,10);
    add(*box);
    set_border_width(10);
    set_size_request(200, 150);
    show_all();
  }

MyDialog::~MyDialog() {}

Glib::ustring MyDialog::run()
  {
    Gtk::Main::run();
    if (canceled) 
      return "";
    return entry->get_text(); 
  }

void MyDialog::cancel()
  {
    canceled = true;
    hide();
    Gtk::Main::quit();
  }

void MyDialog::okay()
  {
    hide();
    Gtk::Main::quit();
  }

bool MyDialog::key(GdkEventKey* ke)
  {
    if (ke&&ke->keyval == GDK_Return)
       hide();
    return false;
  }

/******************************************************/

void pop_dialog()
  {
    MyDialog dialog("What is your name?");
    std::cout << dialog.run() << std::endl;
  }

int
main(int argc,char **argv)
  {
    Gtk::Main kit(argc,argv);
    Gtk::Window win;
    Gtk::VBox box;
    Gtk::Button b1("Pop dialog");
    Gtk::Button b2("Quit");
 
    b1.signal_clicked().connect(SigC::slot(&pop_dialog));
    b2.signal_clicked().connect(SigC::slot(win, &Gtk::Widget::hide));
    box.pack_start(b1); 
    box.pack_start(b2); 
    win.add(box);
    win.show_all();
    Gtk::Main::run(win);
    return 0;
  }
