{ TAMWinEnv 1.0
  copyright  AM Software 1998 by Alexander Meeder

  The idea for this component came when I decided to make an application that locks
  the PC just like the Control-Alt-Delete option with Windows NT. I found some usefull
  components on several Delphi pages but I thought it would be nice if all those features
  are assembled within one component. This is the result, use it as you like.

  I want to thank the following people for their 'freeware' components with source-code:
  - TStealth 1.1 - copyright  Amigreen Software 1998 by Janus N. Tondering j@nus.person.dk
  - TIconHide 1.0 - copyright  1998 by Vit Kovalcik vkovalcik@iname.com
  - TWinAccess x.x - copyright  1998 by ???

  The following options/properties are available with this component:
  * AppHideOption, you can hide the application button on the taskbar and the application name
                   within the task-list (the list that appears when you press Ctrl-Alt-Del)
  * DisableScrnSaver, you can disable the screensaver with this property
  * DisableSysKey, you can disable the system keys Control-Alt-Del, Alt-Tab, Control-Esc and the
                   special Win95/98 Start-button
  * HideOption, with this property-set you can hide any combination of the following options:
                   - Taskbar (the bar with al the buttons of active apps)
                   - TrayClock (the clock on the system tray)
                   - System tray
                   - Taskbar buttons
                   - Start-button
                   - Icons on the desktop

  If you have some questions about, or suggestions for this component
  you can mail me at: ameeder@dds.nl
}

unit AMWinEnv;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs;

type
  TAppHideOption = (hoTaskbarButton, hoTasklistItem);
  TAppHideOptions = set of TAppHideOption;
  THideOption = (hoTrayBar, hoTrayNotify, hoStartButton, hoAppSwitchBar, hoTrayClock, hoDesktopIcons);
  THideOptions = set of THideOption;

  TAMWinEnv = class(TComponent)
  private
    FSysClasses : array [0 .. 6] of PChar;

    FAppHideOption: TAppHideOptions;
    FDisableScrnSaver: boolean;
    FDisableSysKey: boolean;
    FHideOption: THideOptions;

    procedure SetAppHideOption(Value: TAppHideOptions);
    procedure SetDisableScrnSaver(Value: boolean);
    procedure SetDisableSysKey(Value: boolean);
    procedure SetHideOption(Value: THideOptions);

    procedure AppMessage(var msg: TMsg; var Handled: boolean);
  protected
    procedure HideApplication;
    procedure ShowApplication;
    procedure HideOpt(Option: word; Hide: boolean);
  public
    constructor Create(AOwner: TComponent); override;
    destructor Destroy; override;
  published
    property AppHideOption: TAppHideOptions read FAppHideOption write SetAppHideOption;
    property DisableScrnSaver: boolean read FDisableScrnSaver write SetDisableScrnSaver default false;
    property DisableSysKey: boolean read FDisableSysKey write SetDisableSysKey default false;
    property HideOption: THideOptions read FHideOption write SetHideOption;
  end;

function RegisterServiceProcess(dwProcessID, dwType: integer): integer; stdcall; external 'KERNEL32.DLL';

procedure Register;

implementation

const
  iTRAYBAR = 0;
  iTRAYNOTIFY = 1;
  iSTARTBUTTON = 2;
  iAPPSWITCHBAR = 3;
  iTRAYCLOCK = 4;
  iDESKTOPICONS = 5;
  iPROGMAN = 6;

var
  XWndLong: integer;

procedure TAMWinEnv.HideApplication;
begin
  if not (csDesigning in ComponentState) then
    RegisterServiceProcess(GetCurrentProcessID, 1);
end;

procedure TAMWinEnv.ShowApplication;
begin
  if not (csDesigning in ComponentState) then
    RegisterServiceProcess(GetCurrentProcessID, 0);
end;

procedure TAMWinEnv.HideOpt(Option: word; Hide: Boolean);
var
  Wnd: THandle;
begin
  case Option of
    iTRAYBAR      : Wnd := FindWindow(FSysClasses[iTRAYBAR], nil);
    iTRAYNOTIFY   : begin
                      Wnd := FindWindow(FSysClasses[iTRAYBAR], nil);
                      Wnd := FindWindowEx(Wnd, HWND(0), FSysClasses[iTRAYNOTIFY], nil);
                    end;
    iSTARTBUTTON  : begin
                      Wnd := FindWindow(FSysClasses[iTRAYBAR], nil);
                      Wnd := FindWindowEx(Wnd, HWND(0), FSysClasses[iSTARTBUTTON], nil);
                    end;
    iAPPSWITCHBAR : begin
                      Wnd := FindWindow(FSysClasses[iTRAYBAR], nil);
                      Wnd := FindWindowEx(Wnd, HWND(0), FSysClasses[iAPPSWITCHBAR], nil);                      
                      //Wnd := FindWindowEx(Wnd, HWND(0), FSysClasses[iAPPSWITCHBAR], nil);
                    end;
    iTRAYCLOCK    : begin
                      Wnd := FindWindow(FSysClasses[iTRAYBAR], nil);
                      Wnd := FindWindowEx(Wnd, HWND(0), FSysClasses[iTRAYNOTIFY], nil);
                      Wnd := FindWindowEx(Wnd, HWND(0), FSysClasses[iTRAYCLOCK], nil);
                    end;
    iDESKTOPICONS : begin
                      Wnd := FindWindow(FSysClasses[iPROGMAN], nil);
                      Wnd := FindWindowEx(Wnd, HWND(0), FSysClasses[iDESKTOPICONS], nil);
                    end;
    else
      Wnd := 0;
  end;

  if Wnd <> 0 then
  begin
    if Hide then
      ShowWindow(Wnd, SW_HIDE)
    else
      ShowWindow(Wnd, SW_SHOW);
  end;
end;

procedure TAMWinEnv.AppMessage(var msg: TMsg; var Handled: boolean);
begin
  if (msg.message = wm_SysCommand) and (msg.wParam = sc_ScreenSave) then Handled := true;
end;

procedure TAMWinEnv.SetAppHideOption(Value: TAppHideOptions);
begin
  if Value <> FAppHideOption then
  begin
    FAppHideOption := Value;

    if not (csDesigning in ComponentState) then
    begin
      ShowWindow(Application.Handle, SW_HIDE);
      if (hoTaskbarButton in AppHideOption) then
        SetWindowLong(Application.Handle, GWL_EXSTYLE, XWndLong or WS_EX_TOOLWINDOW and not WS_EX_APPWINDOW or WS_EX_TOPMOST)
      else
        SetWindowLong(Application.Handle, GWL_EXSTYLE, XWndLong);

      if (hoTasklistItem in AppHideOption) then
        HideApplication
      else
        ShowApplication;

      ShowWindow(Application.Handle, SW_SHOW);
    end;
  end;
end;

procedure TAMWinEnv.SetDisableScrnSaver(Value: boolean);
begin
  if Value <> FDisableScrnSaver then
  begin
    FDisableScrnSaver := Value;
    if not (csDesigning in ComponentState) then
    begin
      if FDisableScrnSaver then
        Application.OnMessage := AppMessage
      else
        Application.OnMessage := nil;
    end;
  end;
end;

procedure TAMWinEnv.SetDisableSysKey(Value: boolean);
var
  Dummy: integer;
begin
  if Value <> FDisableSysKey then
  begin
    FDisableSysKey := Value;
    if FDisableSysKey then
      SystemParametersInfo(SPI_SCREENSAVERRUNNING, 1, @Dummy, 0)
    else
      SystemParametersInfo(SPI_SCREENSAVERRUNNING, 0, @Dummy, 0);
  end
end;

procedure TAMWinEnv.SetHideOption(Value: THideOptions);
begin
  if Value <> FHideOption then
  begin
    FHideOption := Value;

    if not (csDesigning in ComponentState) then
    begin
      if (hoTrayNotify in HideOption) then
        HideOpt(iTRAYNOTIFY, True)
      else
        HideOpt(iTRAYNOTIFY, False);

      if (hoAppSwitchBar in HideOption) then
        HideOpt(iAPPSWITCHBAR, True)
      else
        HideOpt(iAPPSWITCHBAR, False);

      if (hoStartButton in HideOption) then
        HideOpt(iSTARTBUTTON, True)
      else
        HideOpt(iSTARTBUTTON, False);

      if (hoTrayClock in HideOption) then
        HideOpt(iTRAYCLOCK, True)
      else
        HideOpt(iTRAYCLOCK, False);

      if (hoTrayBar in HideOption) then
        HideOpt(iTRAYBAR, True)
      else
        HideOpt(iTRAYBAR, False);

      if (hoDesktopIcons in HideOption) then
        HideOpt(iDESKTOPICONS, True)
      else
        HideOpt(iDESKTOPICONS, False);
    end;
  end;
end;

constructor TAMWinEnv.Create(AOwner: TComponent);
begin
  inherited Create(AOwner);

  FDisableScrnSaver := False;
  FDisableSysKey := False;

  FSysClasses[iTRAYBAR] := 'Shell_TrayWnd';
  FSysClasses[iTRAYNOTIFY] := 'TrayNotifyWnd';
  FSysClasses[iSTARTBUTTON] := 'Button';
  FSysClasses[iAPPSWITCHBAR] := 'ReBarWindow32';
  FSysClasses[iTRAYCLOCK] := 'TrayClockWClass';
  FSysClasses[iDESKTOPICONS] := 'ShellDll_DefView';
  FSysClasses[iPROGMAN] := 'Progman';
end;

destructor TAMWinEnv.Destroy;
begin
  DisableSysKey := False;
  HideOpt(iSTARTBUTTON, False);
  HideOpt(iTRAYCLOCK, False);  
  HideOpt(iAPPSWITCHBAR, False);
  HideOpt(iTRAYNOTIFY, False);
  HideOpt(iTRAYBAR, False);
  HIdeOpt(iDESKTOPICONS, False);
  ShowApplication;
  inherited Destroy;
end;

procedure Register;
begin
  RegisterComponents('AM Software', [TAMWinEnv]);
end;

initialization
  XWndLong := GetWindowLong(Application.Handle, GWL_EXSTYLE);
end.
