#!/usr/bin/env ruby

require 'iconv'

MaxCol = 16

All          = 0x21..0x7E
Non_Kanji    = 0x21..0x28 # Area 01-08 in JIS X 0208
Undefined1   = 0x29..0x2F # 09-15
Kanji_Level1 = 0x30..0x4F # 16-47
Kanji_Level2 = 0x50..0x74 # 48-84
Undefined2   = 0x75..0x7E # 85-94

#Areas = Kanji_Level2
Areas = All

Points = 0x20..0x7F


# Results of conversion depends on conversion table. I recommend to use GNU's
# iconv table.
# If you use EUC-JP-MS, you can also add enviroment depended characters such as
# NEC exetended characters, but it's not suitable for "JIS X 0208" table.
iconv = Iconv.new('UTF-8', 'EUC-JP')

Areas.each do |c1|

  col = 1

  Points.each do |c2|

    # convert JIS X 0208 to EUC-JP
    c1_euc = c1 | 0x80
    c2_euc = c2 | 0x80
    str = [c1_euc, c2_euc].pack("CC")

    # convert EUC-JP to UTF-8
    # Invalid entries and undidefined entries of JIS X 0208 will be rejected by
    # GNU iconv at this time, so I don't verify it manually.
    begin
      str_utf8 = iconv.iconv(str)
    rescue
      str_utf8 = "  "
#      str_utf8 = nil
    end

    # print out
    if col == 1
      printf "%02d: ", (c1 - 0x20)
    end

    printf "%s", str_utf8 if str_utf8

    if col == MaxCol
      printf "\n"
      col = 1
    else
      printf " "
      col = col + 1
    end
  end
end
