# -*- coding: utf-8 -*-

import gobject
import gtk
import xml.parsers.expat
import os

class OpenXML:
	def __init__(self, mainwin):
		self.mainwin = mainwin

	def start_element(self, name, attrs):
		if name == "character":
			self.utf8chars = ""
		elif name == "utf8":
			self.in_utf8 = True
		elif name == "strokes":
			self.strokes = []
		elif name == "stroke":
			self.stroke = []
		elif name == "point":
			self.stroke.append((int(attrs["x"]), int(attrs["y"])))

	def end_element(self, name):
		if name == "character":
			self.mainwin.char_liststore.append([self.utf8chars, self.strokes, bool(self.strokes)])
		elif name == "utf8":
			self.in_utf8 = False
		elif name == "strokes":
			pass
		elif name == "stroke":
			self.strokes.append(self.stroke)

	def char_data(self, data):
		if self.in_utf8:
			self.utf8chars = self.utf8chars + data

	def open_xmlfile(self, filename):
		# When the column is sorted, it will become very slow, so create a new one.
		self.mainwin.enable_network = False
		self.mainwin.char_liststore = gtk.ListStore(gobject.TYPE_STRING, object, gobject.TYPE_BOOLEAN)
		self.in_utf8 = False
		p = xml.parsers.expat.ParserCreate()
		p.StartElementHandler = self.start_element
		p.EndElementHandler = self.end_element
		p.CharacterDataHandler = self.char_data
		xmlfile = file(filename)
		p.ParseFile(xmlfile)

	def do_open(self):
		dialog = gtk.FileChooserDialog ("Select tomoe XML file", 
				self.mainwin, 
				gtk.FILE_CHOOSER_ACTION_OPEN,
				(gtk.STOCK_OPEN, gtk.RESPONSE_OK,
				 gtk.STOCK_CANCEL, gtk.RESPONSE_CLOSE))
		xmlfilter = gtk.FileFilter()
		xmlfilter.set_name("Tomoe XML file")
		xmlfilter.add_pattern("*.xml")
		allfilter = gtk.FileFilter()
		allfilter.set_name("Any file")
		allfilter.add_pattern("*")
		dialog.add_filter(xmlfilter)
		dialog.add_filter(allfilter)
		dialog.set_default_response (gtk.RESPONSE_OK)
		dialog.set_position (gtk.WIN_POS_CENTER_ON_PARENT)
		dialog.set_current_folder(os.getenv("PWD") + "/data");
		retval = dialog.run ()
		if retval == gtk.RESPONSE_OK:
			self.open_xmlfile(dialog.get_filename())
		dialog.destroy ()

