# -*- coding: utf-8 -*-

import gtk
import os

class SaveXML:
	def __init__(self, char_liststore):
		self.liststore = char_liststore

	def write_strokes(self, model, path, iter, xmlfile):
		utf8str = model.get_value(iter, 0)
		strokes = model.get_value(iter, 1)
		xmlfile.write("  <character>\n    <utf8>")
		unichars = unicode(utf8str, "UTF-8")
		for unichar in unichars:
			xmlfile.write("&#x%X;"%(ord(unichar)))
		xmlfile.write("</utf8>\n    <strokes>\n")
		for stroke in strokes:
			xmlfile.write("      <stroke>\n")
			for points in stroke:
				xmlfile.write("        <point x=\"")
				xmlfile.write(str(int(points[0])))
				xmlfile.write("\" y=\"")
				xmlfile.write(str(int(points[1])))
				xmlfile.write("\"/>\n")
			xmlfile.write("      </stroke>\n")
		xmlfile.write("    </strokes>\n  </character>\n")

	def save_xmlfile(self, filename):
		xmlfile = file(filename, 'w')
		xmlfile.write("<?xml version=\"1.0\" standalone=\"no\"?>\n<!DOCTYPE dictionary SYSTEM \"dict.dtd\">\n<dictionary name=\"Tomoe Handwriting Dictionary\">\n")
		self.liststore.foreach(self.write_strokes, xmlfile)
		xmlfile.write("</dictionary>\n")
		xmlfile.close()

	def do_save(self):
		dialog = gtk.FileChooserDialog ("Save to tomoe XML file", 
				None, 
				gtk.FILE_CHOOSER_ACTION_SAVE,
				(gtk.STOCK_SAVE, gtk.RESPONSE_OK,
				 gtk.STOCK_CANCEL, gtk.RESPONSE_CLOSE))
		dialog.set_do_overwrite_confirmation(True)
		dialog.set_default_response (gtk.RESPONSE_OK)
		dialog.set_position (gtk.WIN_POS_CENTER_ON_PARENT)
		dialog.set_current_folder(os.getenv("PWD") + "/data");
		retval = dialog.run ()
		if retval == gtk.RESPONSE_OK:
			self.save_xmlfile(dialog.get_filename())
		dialog.destroy ()

