#ifndef MYICQ_H_
#define MYICQ_H_

typedef unsigned char uint8;
typedef unsigned short uint16;
typedef unsigned long uint32;

struct ContactInfo {
	uint32 uin;
	gchar* domain;
	uint8 face;
	gchar* nick;
	uint8 age;
	uint8 gender;
	gchar* country;
	gchar* province;
	gchar* city;

	gchar* email;
	gchar* address;
	gchar* zipcode;
	gchar* tel;

	gchar* name;
	uint8 blood;
	gchar* college;
	gchar* occupation;
	gchar* homepage;
	gchar* intro;
	
	uint8 auth; // used when send UDP_MODIFY_USER packet.
	uint8 is_modify_passwd;
	gchar* password;
};

struct myicq_buddy {
	uint32 uin;
	gchar *domain;
	uint32 ip;
	uint32 real_ip;
	uint16 port;	
	gboolean try_connected; //when send message for the first time,try to connect him direct,and then set this varible to TRUE.
};

struct search_user_info
{
	uint32 uin;
	uint8 online,face;
	gchar *nick,*province;
};

struct search_server_info
{
	gchar *domain,*desc;
	uint32 sessionCount;
};

struct search_group_info
{
	uint32 id;
	gchar *name;
	uint16 type;
	uint16 num;
};

struct search_dialog
{
	struct gaim_connection *gc;
	GtkWidget *window,*notebook,*back_button,*next_button,*cancel_button;
	GtkWidget *radio_online_user,*radio_myicq_num,*radio_custom_search,*radio_remote_friend,*radio_group_list,*radio_group_num,*radio_create_group;
	GtkWidget *myicq_num_entry; //search by myicq num
	GtkWidget *group_num_entry; //search by group id
	GtkWidget *search_custom_nick_entry,*search_custom_email_entry; //search custom
	uint32 customSearch_startUIN; //search custom
	GtkWidget *user_list_treeview,*user_list_info_label,*user_list_previous_button,*user_list_next_button,*user_list_all_button,*user_list_detail_button;
	GtkWidget *add_friend_uin_label,*add_friend_nick_label,*add_friend_info_label,*add_friend_image,*add_friend_textview,*add_friend_hbox;
	GtkWidget *server_list_treeview,*server_list_label;
	GtkWidget *group_type_list_treeview;
	GtkWidget *group_list_treeview,*group_list_info_label,*group_list_password_entry;
	GtkWidget *create_group_name_entry,*create_group_password_entry;
	GtkWidget *create_group_result_info_label;
	gint nb_current_page;
	gint nb_choose_radio;
	GSList *search_user_result_page_list;
	gboolean have_server_list;
	GSList *search_server_list;
	GSList *search_group_list;
	gint search_user_result_current_page;
};

struct serv_group_type{
	gchar *name;
	gchar *displayname;
};

struct myicq_data {	
	int fd; //UDP sock.connect to server. or tcp sock connect to http proxy.
	int filelistenSock; //my listen sock.for file receive and send.
	int filelistenInpa;
	
	char subkey[128]; // for des encrypt.

	int msglistenSock; //my tcp msg listen sock.
	int msglistenInpa;

	char *myicq_server_host;
	int myicq_server_port;
	
	int socks5proxySock; //socks5 proxy 's tcp listen sock.
	int socks5proxyInpa;
	
	char *rxqueue; // when connect by http proxy.
	int rxlen;

	uint32 myuin; //these varible read often when create packet head,so add here to save converting time;
	uint8 face;
	gchar domain[64];
	
	uint32 sid;			// Session ID
	uint16 sendSeq;
	uint32 sessionCount;	// The number of currently online users
	uint8 window[1 << 13];  // To see whether this is a duplicated packet. 2^13 bytes == 2^16 bits
	gboolean online; //used by KEEPALIVE packet processing.
	gboolean logged_in;  //used by myicq_add_buddy().
	uint32 ourIP; //ip from the server's point of view, in case of NAT, this is different from our real ip
	gboolean loginmethod; //login invisible,away or online.
	gint sendqueue_timeout;
	gint tcpmsgsendqueue_timeout;
	GList *sendqueue;
	GList *tcpmsgsendqueue;
	GList *updatingContactInfo;
	struct search_dialog *searchDlg;
	GSList *servgrouptype;
	GList *onlinebuddy;
	GList *tcpfileConnection;
	GList *tcpmsgConnection;
};

struct myicq_tcpfileconnection {
	struct gaim_connection *gc;
	int connsock;
	int inpa;
	char *rxqueue;
	int rxlen;

	char *sendqueue; // contact's tcp direct connect send buffer.
	int sendlen;

	uint8 isSend; // file send or receive.
	
	FILE *file;
	char *filename;
	uint32 filesize;
	uint32 bytesSent;
	time_t start_time;
	int update_timeout;
	GtkWidget *window,*progressbar,*speed_label;	// progress window
	GtkWidget *choosefile_dialog;
};

struct myicq_tcpmsgconnection {
	struct gaim_connection *gc;
	int connsock;
	int inpa;
	char *rxqueue;
	int rxlen;
	
	uint32 uin;
	gchar *domain;
	uint8 isSend;
	
	uint32 msgID; // message seq.
};

struct _updatingContactInfo{
	uint32 uin;
	gchar *domain;
	GtkWidget *window;
	GtkWidget *refresh_button[4];
	GtkWidget *face,*uin_entry,*nick,*country,*age,*gender,*province,*city,*email,*address,*zipcode,*tel,*name,*blood,*college,
				*occupation,*homepage,*intro;
	GtkWidget *auth_radio[3],*is_modify_passwd, *old_password, *password[2];
};

// Message types
enum {
	MSG_TEXT,
	MSG_AUTO_REPLY,
	MSG_AUTH_ACCEPTED,
	MSG_AUTH_REQUEST,
	MSG_AUTH_REJECTED,
	MSG_ADDED,
	MSG_TCP_REQUEST,
	MSG_TCP_ACCEPTED,
	MSG_TCP_REJECTED,
};

extern GdkPixbuf * get_face_gdkpixbuf(int i);

extern void myicq_send_packet_searchUin(uint32 uin, const char *domain, struct gaim_connection *gc);
extern void myicq_send_packet_searchCustom(const char *nick, const char *email,uint32 start_uin,struct gaim_connection *gc);
extern void myicq_send_packet_searchRandom(const char *domain, struct gaim_connection *gc);
extern void myicq_send_packet_searchGroup(uint32 id, struct gaim_connection *gc);
extern void myicq_send_packet_updateContact(uint32 uin, const gchar *domain, struct gaim_connection *gc);
extern void myicq_send_packet_updateUser(struct gaim_connection *gc);
extern void myicq_send_packet_modifyUser(struct ContactInfo *info, struct gaim_connection *gc);
extern void myicq_send_packet_addfriend(struct gaim_connection *gc, const char *name);
extern void myicq_send_packet_msg(uint8 type, uint32 to_uin, gchar *to_uin_domain, char *message, struct gaim_connection *gc);
extern void myicq_send_packet_getServerList(struct gaim_connection *gc);
extern void myicq_send_packet_getGroupList(uint16 type, struct gaim_connection *gc);
extern void myicq_send_packet_createGroup(uint16 type, const char *name,const char *pass, struct gaim_connection *gc);
extern void myicq_send_packet_enterGroup(uint32 id, const char *pass, struct gaim_connection *gc);
extern void myicq_tcpfileconnection_kill(struct myicq_tcpfileconnection *mtfc);
extern void myicq_get_info(struct gaim_connection *gc, char *who);

#endif
