#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include "searchdlg.h"

#include "gaim.h"
#include <gtk/gtk.h>
#include <stdlib.h>
#include <sys/stat.h>
#include <string.h>
#include <stdio.h>


enum{
	NB_CHOOSE_RADIO_RANDOM_SEARCH = 0,
	NB_CHOOSE_RADIO_MYICQ_NUM,
	NB_CHOOSE_RADIO_CUSTOM_SEARCH,
	NB_CHOOSE_RADIO_REMOTE_FRIEND,
	NB_CHOOSE_RADIO_GROUP_LIST,
	NB_CHOOSE_RADIO_GROUP_NUM,
	NB_CHOOSE_RADIO_CREATE_GROUP,
};

static void
search_window_deleteevent (GtkWidget * widget, GdkEvent * event, gpointer data)
{
	gtk_widget_destroy (widget);
}

static void
search_dialog_back (GtkWidget * widget, struct search_dialog *sd)
{
	gint back_page;
	switch (sd->nb_current_page)
	{
		case NB_MYICQ_NUM:
			back_page = NB_CHOOSE;
			break;
		case NB_CUSTOM_SEARCH:
			back_page = NB_CHOOSE;
			break;
		case NB_USER_LIST:
			if (sd->nb_choose_radio == NB_CHOOSE_RADIO_RANDOM_SEARCH)
				back_page = NB_CHOOSE;
			else if (sd->nb_choose_radio == NB_CHOOSE_RADIO_MYICQ_NUM)
				back_page = NB_MYICQ_NUM;
			else if (sd->nb_choose_radio == NB_CHOOSE_RADIO_CUSTOM_SEARCH)
				back_page = NB_CUSTOM_SEARCH;
			else if (sd->nb_choose_radio == NB_CHOOSE_RADIO_REMOTE_FRIEND)
				back_page = NB_SERVER_LIST;
			else
				back_page = NB_CHOOSE;
			break;
		case NB_ADD_FRIEND:
			back_page = NB_USER_LIST;
			break;
		case NB_GROUP_TYPE_LIST:
			back_page = NB_CHOOSE;
			break;
		case NB_GROUP_LIST:
			if (sd->nb_choose_radio == NB_CHOOSE_RADIO_GROUP_LIST)
				back_page = NB_GROUP_TYPE_LIST;
			else if (sd->nb_choose_radio == NB_CHOOSE_RADIO_GROUP_NUM)
				back_page = NB_GROUP_NUM;
			else
				back_page = NB_CHOOSE;
			break;
		case NB_CREATE_GROUP:
			back_page = NB_GROUP_TYPE_LIST;
			break;
		case NB_CREATE_GROUP_RESULT:
			if (sd->nb_choose_radio == NB_CHOOSE_RADIO_GROUP_LIST)
				back_page = NB_GROUP_LIST;
			else if (sd->nb_choose_radio == NB_CHOOSE_RADIO_GROUP_NUM)
				back_page = NB_GROUP_LIST;
			else if (sd->nb_choose_radio == NB_CHOOSE_RADIO_CREATE_GROUP)
				back_page = NB_CREATE_GROUP;
			else
				back_page = NB_CHOOSE;
			break;
		case NB_GROUP_NUM:
			back_page = NB_CHOOSE;
			break;
		default:
			back_page = NB_CHOOSE;
	}
	gtk_notebook_set_current_page (GTK_NOTEBOOK (sd->notebook), back_page);
	sd->nb_current_page = back_page;	
	if (sd->nb_current_page==NB_CHOOSE)
		gtk_widget_set_sensitive(sd->back_button,FALSE);
}

static void
search_dialog_clean_search_user_result (struct search_dialog *sd)
{
	GSList *user_info_list;
	struct search_user_info *user;
	while (sd->search_user_result_page_list)
	{
		user_info_list = (GSList *)(sd->search_user_result_page_list->data);
		while (user_info_list)
		{
			user = (struct search_user_info *)(user_info_list->data);
			g_free(user->nick);
			g_free(user->province);
			g_free(user);
			user_info_list = g_slist_remove(user_info_list,user);
		}
		sd->search_user_result_page_list = g_slist_remove(sd->search_user_result_page_list,sd->search_user_result_page_list->data);
	}	
	gtk_list_store_clear(GTK_LIST_STORE(gtk_tree_view_get_model(GTK_TREE_VIEW(sd->user_list_treeview))));
	gtk_label_set_text(GTK_LABEL(sd->user_list_info_label),_("Searching..."));
	gtk_widget_set_sensitive(sd->user_list_previous_button,FALSE);
	gtk_widget_set_sensitive(sd->user_list_next_button,FALSE);
	gtk_widget_set_sensitive(sd->user_list_all_button,FALSE);
	sd->search_user_result_current_page = -2; //so it is not equal to -1 and 0,1,2,3....so can do a fresh.
	sd->customSearch_startUIN = 0;
}

static void
search_dialog_clean_search_group_result (struct search_dialog *sd)
{
	struct search_group_info *group;
	while (sd->search_group_list)
	{
		group = (struct search_group_info *)(sd->search_group_list->data);
		g_free(group->name);
		g_free(group);
		sd->search_group_list = g_slist_remove(sd->search_group_list,group);
	}

	gtk_list_store_clear(GTK_LIST_STORE(gtk_tree_view_get_model(GTK_TREE_VIEW(sd->group_list_treeview))));
	gtk_label_set_text(GTK_LABEL(sd->group_list_info_label),_("Searching..."));
}

static void
search_dialog_clean_search_server_result (struct search_dialog *sd)
{
	struct search_server_info *server;
	while (sd->search_server_list)
	{
		server = (struct search_server_info *)(sd->search_server_list->data);
		g_free(server->domain);
		g_free(server->desc);
		g_free(server);
		sd->search_server_list = g_slist_remove(sd->search_server_list,server);
	}
}

void
search_dialog_refresh_search_user_result (struct search_dialog *sd,gint refresh_page)
{
	GSList *page_list;
	GSList *user_info_list;
	struct search_user_info *user;
	GtkListStore *list_store;
	GtkTreeIter iter;
	gchar bud[256];
	gint total_page;
	GdkPixbuf *pixbuf;
	gint face_num;
	
	if (refresh_page==sd->search_user_result_current_page)
		return;
	total_page= g_slist_length(sd->search_user_result_page_list);
	if (refresh_page==-1) //all page.
		page_list = sd->search_user_result_page_list;
	else
		page_list = g_slist_nth(sd->search_user_result_page_list,refresh_page);

	list_store=GTK_LIST_STORE(gtk_tree_view_get_model(GTK_TREE_VIEW(sd->user_list_treeview)));
	gtk_list_store_clear(list_store);
	while (page_list)
	{
		user_info_list = (GSList *)(page_list->data);
		while (user_info_list)
		{
			user = (struct search_user_info*)(user_info_list->data);
			sprintf(bud,"%lu",user->uin);
			face_num = (user->face)*3;
			if (!user->online)
				face_num+=1;
			pixbuf = get_face_gdkpixbuf(face_num);
			gtk_list_store_append (list_store, &iter);
			gtk_list_store_set (list_store, &iter,
			  	0, pixbuf,//head icon pixbuf
				1,bud,
				2,user->nick,
				3,user->province,
				4,user->face,
				-1);
			g_object_unref(pixbuf);
			user_info_list = g_slist_next(user_info_list);
		}

		if (refresh_page==-1)
			page_list = g_slist_next(page_list);
		else
			page_list = NULL;
	}
	if (refresh_page==total_page-1) //the last page
	{
		page_list = g_slist_last(sd->search_user_result_page_list);
		user_info_list = (GSList *)(page_list->data);
		if (!user_info_list) //find no user.
		{
			sd->customSearch_startUIN = -1;
		}
		else
		{
			user_info_list = g_slist_last(user_info_list);
			user = (struct search_user_info*)(user_info_list->data);			
			sd->customSearch_startUIN = user->uin; //the last user has the max number.
		}
	}

	if (refresh_page != -1)
		sprintf(bud,_("Result of page %d(%d)"),refresh_page+1,total_page);
	else
		sprintf(bud,_("All result(%d page in total)"),total_page);
	gtk_label_set_text(GTK_LABEL(sd->user_list_info_label),bud);
	if (refresh_page!=0)
		gtk_widget_set_sensitive(sd->user_list_previous_button,TRUE);
	else
		gtk_widget_set_sensitive(sd->user_list_previous_button,FALSE);
	gtk_widget_set_sensitive(sd->user_list_next_button,TRUE);
	gtk_widget_set_sensitive(sd->user_list_all_button,TRUE);	
	
	sd->search_user_result_current_page = refresh_page;
	gtk_window_present(GTK_WINDOW(sd->window));
}

void
search_dialog_refresh_search_group_result (struct search_dialog *sd)
{
	GSList *group_info_list;
	struct search_group_info *group;
	GtkListStore *list_store;
	GtkTreeIter iter;
	
	list_store=GTK_LIST_STORE(gtk_tree_view_get_model(GTK_TREE_VIEW(sd->group_list_treeview)));
	gtk_list_store_clear(list_store);
	group_info_list = sd->search_group_list;
	while (group_info_list)
	{
		group = (struct search_group_info*)(group_info_list->data);
		gtk_list_store_append (list_store, &iter);
		gtk_list_store_set (list_store, &iter,
			  	0, group->id,
				1,group->name,
				2,group->num,
				-1);
		group_info_list = g_slist_next(group_info_list);
	}
	gtk_label_set_text(GTK_LABEL(sd->group_list_info_label),_("Completed"));
}

void
search_dialog_refresh_search_server_result (struct search_dialog *sd)
{
	GSList *server_info_list;
	struct search_server_info *server;
	GtkListStore *list_store;
	GtkTreeIter iter;
	
	list_store=GTK_LIST_STORE(gtk_tree_view_get_model(GTK_TREE_VIEW(sd->server_list_treeview)));
	gtk_list_store_clear(list_store);
	server_info_list = sd->search_server_list;
	while (server_info_list)
	{
		server = (struct search_server_info*)(server_info_list->data);
		gtk_list_store_append (list_store, &iter);
		gtk_list_store_set (list_store, &iter,
			  	0, server->domain,
				1,server->sessionCount,
				2,server->desc,
				-1);
		server_info_list = g_slist_next(server_info_list);
	}
	gtk_label_set_text(GTK_LABEL(sd->server_list_label),_("Completed"));
}

static void
search_dialog_destroy (GtkWidget * widget, struct search_dialog *sd)
{
	struct myicq_data *md = sd->gc->proto_data;
	search_dialog_clean_search_user_result(sd);
	search_dialog_clean_search_server_result(sd);
	search_dialog_clean_search_group_result(sd);
	g_free(sd);
	md->searchDlg = NULL;
}

static gint
nb_user_list_next (struct search_dialog *sd)
{
	GtkTreeModel *model;
	GtkTreeIter iter;	
	
	if (gtk_tree_selection_get_selected (gtk_tree_view_get_selection (GTK_TREE_VIEW (sd->user_list_treeview)), &model, &iter))
	{
		gint face_num;
		gchar *nick;
		GdkPixbuf *pixbuf;
		gtk_tree_model_get (model, &iter,2,&nick,4,&face_num,-1);
		gtk_label_set_text(GTK_LABEL(sd->add_friend_nick_label),nick);	
		gtk_label_set_text(GTK_LABEL(sd->add_friend_info_label),_("Waiting the add friend reply..."));			
		pixbuf = get_face_gdkpixbuf(face_num*3);
		gtk_image_set_from_pixbuf(GTK_IMAGE(sd->add_friend_image),pixbuf);
		gtk_widget_hide(sd->add_friend_hbox);
		g_object_unref(pixbuf);
		if (sd->nb_choose_radio == NB_CHOOSE_RADIO_MYICQ_NUM)
		{
			const gchar* bud;
			bud = gtk_entry_get_text(GTK_ENTRY(sd->myicq_num_entry));
			gtk_label_set_text(GTK_LABEL(sd->add_friend_uin_label), bud);
			myicq_send_packet_addfriend(sd->gc,bud);
		}
		else if (sd->nb_choose_radio == NB_CHOOSE_RADIO_REMOTE_FRIEND)
		{
			GtkTreeModel *serv_list_model;
			GtkTreeIter serv_list_iter;	
			if (gtk_tree_selection_get_selected (gtk_tree_view_get_selection (GTK_TREE_VIEW (sd->server_list_treeview)), &serv_list_model, &serv_list_iter))
			{
				gchar *domain;
				gchar *uin;
				gchar *bud;
				gtk_tree_model_get (serv_list_model, &serv_list_iter,0,&domain,-1);						
				gtk_tree_model_get (model, &iter,1, &uin,-1);
				bud = g_strdup_printf("%s@%s",uin,domain);
				gtk_label_set_text(GTK_LABEL(sd->add_friend_uin_label),bud);		
				myicq_send_packet_addfriend(sd->gc,bud);
				g_free(domain);
				g_free(uin);
				g_free(bud);
			}			
		}
		else
		{
			gchar *bud;
			gtk_tree_model_get (model, &iter,1, &bud,-1);
			gtk_label_set_text(GTK_LABEL(sd->add_friend_uin_label),bud);		
			myicq_send_packet_addfriend(sd->gc,bud);
			g_free(bud);
		}
	}
	else
	{
		do_error_dialog(_("Error"), _("Please select one user!"), GAIM_ERROR);
		return -1;
	}

	return NB_ADD_FRIEND;
}

static gint
nb_server_list_next (struct search_dialog *sd)
{
	GtkTreeModel *model;
	GtkTreeIter iter;	
	
	if (gtk_tree_selection_get_selected (gtk_tree_view_get_selection (GTK_TREE_VIEW (sd->server_list_treeview)), &model, &iter))
	{
		gchar *domain;
		gtk_tree_model_get (model, &iter,0,&domain,-1);
		search_dialog_clean_search_user_result(sd);
		myicq_send_packet_searchRandom(domain,sd->gc);
		g_free(domain);
	}
	else
	{
		do_error_dialog(_("Error"), _("Please select one server!"), GAIM_ERROR);
		return -1;
	}

	return NB_USER_LIST;
}

static gint
nb_group_list_next (struct search_dialog *sd)
{
	GtkTreeModel *model;
	GtkTreeIter iter;	
	
	if (gtk_tree_selection_get_selected (gtk_tree_view_get_selection (GTK_TREE_VIEW (sd->group_list_treeview)), &model, &iter))
	{
		uint32 id;
		gtk_label_set_text(GTK_LABEL(sd->create_group_result_info_label),_("Waiting the enter group reply..."));
		gtk_tree_model_get (model, &iter,0,&id,-1);
		myicq_send_packet_enterGroup(id,gtk_entry_get_text(GTK_ENTRY(sd->group_list_password_entry)),sd->gc);
		return NB_CREATE_GROUP_RESULT;
	}
	else
	{
		do_error_dialog(_("Error"), _("Please select one group!"), GAIM_ERROR);
		return -1;
	}
}

static gint
nb_group_type_list_next (struct search_dialog *sd)
{
	GtkTreeModel *model;
	GtkTreeIter iter;	
	
	if (gtk_tree_selection_get_selected (gtk_tree_view_get_selection (GTK_TREE_VIEW (sd->group_type_list_treeview)), &model, &iter))
	{
		if (sd->nb_choose_radio == NB_CHOOSE_RADIO_GROUP_LIST)
		{
			gint type;
			gtk_tree_model_get (model, &iter,2,&type,-1);
			search_dialog_clean_search_group_result(sd);
			myicq_send_packet_getGroupList(type,sd->gc);

			return NB_GROUP_LIST;
		}
		else if (sd->nb_choose_radio == NB_CHOOSE_RADIO_CREATE_GROUP)
		{
			return NB_CREATE_GROUP;
		}
		else
		{
			return NB_CHOOSE;
		}
	}
	else
	{
		do_error_dialog(_("Error"), _("Please select one group type!"), GAIM_ERROR);
		return -1;
	}
}

static gint
nb_create_group_next (struct search_dialog *sd)
{
	const gchar *text;
	text = gtk_entry_get_text(GTK_ENTRY(sd->create_group_name_entry));
	if (text[0])
	{
		GtkTreeModel *model;
		GtkTreeIter iter;	
	
		if (gtk_tree_selection_get_selected (gtk_tree_view_get_selection (GTK_TREE_VIEW (sd->group_type_list_treeview)), &model, &iter))
		{
			uint16 type;
			gchar *name;
			
			gtk_tree_model_get (model, &iter,2,&type,-1);
			gtk_label_set_text(GTK_LABEL(sd->create_group_result_info_label),_("Waiting the create group reply..."));
			name = g_locale_from_utf8(text,-1,NULL,NULL,NULL);
			myicq_send_packet_createGroup(type, name, gtk_entry_get_text(GTK_ENTRY(sd->create_group_password_entry)), sd->gc);
			return NB_CREATE_GROUP_RESULT;
		}
		else
			return NB_CHOOSE;	
	}
	else
	{
		do_error_dialog(_("Input error"), _("Please input the group name!"), GAIM_ERROR);
		return -1;
	}
}

static gint
nb_group_num_next (struct search_dialog *sd)
{
	uint32 id;
	id = atol(gtk_entry_get_text(GTK_ENTRY(sd->group_num_entry)));
	if (id>0)
	{
		search_dialog_clean_search_group_result(sd);
		myicq_send_packet_searchGroup(id,sd->gc);
		return NB_GROUP_LIST;
	}
	else
	{
		do_error_dialog(_("Input error"), _("Please input the group number!"), GAIM_ERROR);
		return -1;
	}
}

static void
search_dialog_next (GtkWidget * widget, struct search_dialog *sd)
{
	gint next_page = NB_CHOOSE;
	uint32 uin;
	gchar *domain;
	switch (sd->nb_current_page)
	{
		case NB_CHOOSE:			
			if (gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (sd->radio_online_user)))
			{
				next_page=NB_USER_LIST;
				sd->nb_choose_radio = NB_CHOOSE_RADIO_RANDOM_SEARCH;				
				search_dialog_clean_search_user_result(sd);
				myicq_send_packet_searchRandom(NULL,sd->gc);
			}
			else if (gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (sd->radio_myicq_num)))
			{
				next_page=NB_MYICQ_NUM;
				sd->nb_choose_radio = NB_CHOOSE_RADIO_MYICQ_NUM;
			}
			else if (gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (sd->radio_custom_search)))
			{
				next_page=NB_CUSTOM_SEARCH;
				sd->nb_choose_radio = NB_CHOOSE_RADIO_CUSTOM_SEARCH;
			}
			else if (gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (sd->radio_remote_friend)))
			{
				next_page=NB_SERVER_LIST;
				sd->nb_choose_radio = NB_CHOOSE_RADIO_REMOTE_FRIEND;
				if (!sd->have_server_list)
					myicq_send_packet_getServerList(sd->gc);
			}
			else if (gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (sd->radio_group_list)))
			{
				next_page=NB_GROUP_TYPE_LIST;
				sd->nb_choose_radio = NB_CHOOSE_RADIO_GROUP_LIST;
			}
			else if (gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (sd->radio_group_num)))
			{
				next_page=NB_GROUP_NUM;
				sd->nb_choose_radio = NB_CHOOSE_RADIO_GROUP_NUM;
			}
			else if (gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (sd->radio_create_group)))
			{
				next_page=NB_GROUP_TYPE_LIST;
				sd->nb_choose_radio = NB_CHOOSE_RADIO_CREATE_GROUP;
			}
			break;
		case NB_MYICQ_NUM:
			uin = atol(gtk_entry_get_text(GTK_ENTRY(sd->myicq_num_entry)));
			if (uin>0)
			{
				next_page = NB_USER_LIST;
				domain = strchr(gtk_entry_get_text(GTK_ENTRY(sd->myicq_num_entry)),'@');
				if (domain)
					domain++;
				search_dialog_clean_search_user_result(sd);
				myicq_send_packet_searchUin(uin,domain,sd->gc);
			}
			else
			{
				do_error_dialog(_("Input error"), _("The text you inputed don't match the myicq number format!"), GAIM_ERROR);
				return;
			}
			break;
		case NB_CUSTOM_SEARCH:
			if ((gtk_entry_get_text(GTK_ENTRY(sd->search_custom_nick_entry))[0]=='\0')&&(gtk_entry_get_text(GTK_ENTRY(sd->search_custom_email_entry))[0]=='\0'))
			{
				do_error_dialog(_("Input error"), _("Please input some information to search!"), GAIM_ERROR);
				return;
			}
			else
			{
				search_dialog_clean_search_user_result(sd);
				myicq_send_packet_searchCustom(gtk_entry_get_text(GTK_ENTRY(sd->search_custom_nick_entry)),gtk_entry_get_text(GTK_ENTRY(sd->search_custom_email_entry)),sd->customSearch_startUIN,sd->gc);
				next_page = NB_USER_LIST;
			}
			break;
		case NB_USER_LIST:
			next_page = nb_user_list_next(sd);
			if (next_page == -1)
				return;
			break;
		case NB_SERVER_LIST:
			next_page = nb_server_list_next(sd);
			if (next_page == -1)
				return;
			break;
		case NB_GROUP_TYPE_LIST:
			next_page = nb_group_type_list_next(sd);
			if (next_page == -1)
				return;
			break;
		case NB_GROUP_LIST:
			next_page = nb_group_list_next(sd);
			if (next_page == -1)
				return;
			break;
		case NB_CREATE_GROUP:
			next_page = nb_create_group_next(sd);
			if (next_page == -1)
				return;
			break;
		case NB_GROUP_NUM:
			next_page = nb_group_num_next(sd);
			if (next_page == -1)
				return;
			break;
		default:
			next_page = NB_CHOOSE;
	}
	gtk_notebook_set_current_page (GTK_NOTEBOOK (sd->notebook), next_page);
	sd->nb_current_page = next_page;	
	gtk_widget_set_sensitive(sd->back_button,TRUE);
}

static void
search_dialog_cancel (GtkWidget * widget, struct search_dialog *sd)
{
	gtk_widget_destroy(sd->window);	
}

static void create_nb_choose(struct search_dialog *sd)
{
	struct myicq_data *md = sd->gc->proto_data;
	GtkWidget *vbox, *frame, *vbox1, *label,*radio;
	gchar text[256];
	
	vbox = gtk_vbox_new(FALSE,8);
	frame = gtk_frame_new(_("Please choose"));
	vbox1 = gtk_vbox_new(FALSE,6);
	radio = gtk_radio_button_new_with_label(NULL,_("Random search online user"));
	sd->radio_online_user = radio;
	gtk_box_pack_start(GTK_BOX(vbox1),radio,FALSE,FALSE,0);
	radio = gtk_radio_button_new_with_label_from_widget(GTK_RADIO_BUTTON (radio),_("MyICQ number"));
	sd->radio_myicq_num = radio;
	gtk_box_pack_start(GTK_BOX(vbox1),radio,FALSE,FALSE,0);
	radio = gtk_radio_button_new_with_label_from_widget(GTK_RADIO_BUTTON (radio),_("Custom search"));
	sd->radio_custom_search = radio;
	gtk_box_pack_start(GTK_BOX(vbox1),radio,FALSE,FALSE,0);
	radio = gtk_radio_button_new_with_label_from_widget(GTK_RADIO_BUTTON (radio),_("Remote friends"));
	sd->radio_remote_friend = radio;
	gtk_box_pack_start(GTK_BOX(vbox1),radio,FALSE,FALSE,0);	
	radio = gtk_radio_button_new_with_label_from_widget(GTK_RADIO_BUTTON (radio),_("Show group list"));
	sd->radio_group_list = radio;
	gtk_box_pack_start(GTK_BOX(vbox1),radio,FALSE,FALSE,0);	
	radio = gtk_radio_button_new_with_label_from_widget(GTK_RADIO_BUTTON (radio),_("Group number"));
	sd->radio_group_num = radio;	
	gtk_box_pack_start(GTK_BOX(vbox1),radio,FALSE,FALSE,0);
	radio = gtk_radio_button_new_with_label_from_widget(GTK_RADIO_BUTTON (radio),_("Create group"));
	sd->radio_create_group = radio;
	gtk_box_pack_start(GTK_BOX(vbox1),radio,FALSE,FALSE,0);	

	gtk_container_add(GTK_CONTAINER(frame),vbox1);
	gtk_box_pack_start(GTK_BOX(vbox),frame,FALSE,FALSE,0);
		
	if (md->sessionCount>0)
		sprintf(text,_("Online users count:  %lu"),md->sessionCount);
	else
		strcpy(text,_("Online users count:  Unknow"));
	label=gtk_label_new(text);
	gtk_misc_set_alignment (GTK_MISC (label), 0, .5);
	gtk_box_pack_start(GTK_BOX(vbox),label,FALSE,FALSE,0);

	gtk_notebook_append_page(GTK_NOTEBOOK(sd->notebook),vbox,NULL);
}

static void create_nb_myicqNum(struct search_dialog *sd)
{
	GtkWidget *vbox, *label, *entry;
	
	vbox = gtk_vbox_new(FALSE,8);
	label=gtk_label_new(_("Notice:\nInput a MyICQ unique number to search\n a Myicq user in local or remote server.\nIt is in the formal:\n\nMyICQ number[@MyICQ domain]\n\nFor example: 10001@myicq.cosoft.org.cn\n\n\nMyICQ unique number:"));
	gtk_misc_set_alignment (GTK_MISC (label), 0, .5);
	gtk_box_pack_start(GTK_BOX(vbox),label,FALSE,FALSE,0);
	entry=gtk_entry_new();		
	sd->myicq_num_entry = entry;
	g_signal_connect (G_OBJECT (entry), "activate",
				    G_CALLBACK(search_dialog_next), sd);
	gtk_box_pack_start(GTK_BOX(vbox),entry,FALSE,FALSE,0);

	gtk_notebook_append_page(GTK_NOTEBOOK(sd->notebook),vbox,NULL);
}

static void create_nb_customSearch(struct search_dialog *sd)
{
	GtkWidget *vbox, *label, *entry;
	
	vbox = gtk_vbox_new(FALSE,8);
	label=gtk_label_new(_("Notice:\nYou can input one parameter or more to\nsearch the users\n\n"));
	gtk_misc_set_alignment (GTK_MISC (label), 0, .5);
	gtk_box_pack_start(GTK_BOX(vbox),label,FALSE,FALSE,0);
	label=gtk_label_new(_("By nick name:"));
	gtk_misc_set_alignment (GTK_MISC (label), 0, .5);
	gtk_box_pack_start(GTK_BOX(vbox),label,FALSE,FALSE,0);
	entry=gtk_entry_new();	
	sd->search_custom_nick_entry = entry;
	g_signal_connect (G_OBJECT (entry), "activate",
				    G_CALLBACK(search_dialog_next), sd);
	gtk_box_pack_start(GTK_BOX(vbox),entry,FALSE,FALSE,0);
	label=gtk_label_new(_("By email:"));
	gtk_misc_set_alignment (GTK_MISC (label), 0, .5);
	gtk_box_pack_start(GTK_BOX(vbox),label,FALSE,FALSE,0);
	entry=gtk_entry_new();	
	sd->search_custom_email_entry = entry;
	g_signal_connect (G_OBJECT (entry), "activate",
				    G_CALLBACK(search_dialog_next), sd);
	gtk_box_pack_start(GTK_BOX(vbox),entry,FALSE,FALSE,0);

	gtk_notebook_append_page(GTK_NOTEBOOK(sd->notebook),vbox,NULL);
}

static void create_nb_groupNUm(struct search_dialog *sd)
{
	GtkWidget *vbox, *label, *entry;
	
	vbox = gtk_vbox_new(FALSE,8);
	label=gtk_label_new(_("Notice:\nInput the group number."));
	gtk_misc_set_alignment (GTK_MISC (label), 0, .5);
	gtk_box_pack_start(GTK_BOX(vbox),label,FALSE,FALSE,0);
	label=gtk_label_new(_("Group number:"));
	gtk_misc_set_alignment (GTK_MISC (label), 0, .5);
	gtk_box_pack_start(GTK_BOX(vbox),label,FALSE,FALSE,0);
	entry=gtk_entry_new();	
	sd->group_num_entry = entry;
	g_signal_connect (G_OBJECT (entry), "activate",
				    G_CALLBACK(search_dialog_next), sd);
	gtk_box_pack_start(GTK_BOX(vbox),entry,FALSE,FALSE,0);

	gtk_notebook_append_page(GTK_NOTEBOOK(sd->notebook),vbox,NULL);
}

static void create_nb_createGroup(struct search_dialog *sd)
{
	GtkWidget *vbox, *label, *entry;
	
	vbox = gtk_vbox_new(FALSE,8);
	label=gtk_label_new(_("Notice:\nInput the group name and password."));
	gtk_misc_set_alignment (GTK_MISC (label), 0, .5);
	gtk_box_pack_start(GTK_BOX(vbox),label,FALSE,FALSE,0);
	label=gtk_label_new(_("Group name:"));
	gtk_misc_set_alignment (GTK_MISC (label), 0, .5);
	gtk_box_pack_start(GTK_BOX(vbox),label,FALSE,FALSE,0);
	entry=gtk_entry_new();	
	sd->create_group_name_entry = entry;
	g_signal_connect (G_OBJECT (entry), "activate",
				    G_CALLBACK(search_dialog_next), sd);
	gtk_box_pack_start(GTK_BOX(vbox),entry,FALSE,FALSE,0);
	label=gtk_label_new(_("Password:"));
	gtk_misc_set_alignment (GTK_MISC (label), 0, .5);
	gtk_box_pack_start(GTK_BOX(vbox),label,FALSE,FALSE,0);
	entry=gtk_entry_new();	
	sd->create_group_password_entry = entry;
	g_signal_connect (G_OBJECT (entry), "activate",
				    G_CALLBACK(search_dialog_next), sd);
	gtk_box_pack_start(GTK_BOX(vbox),entry,FALSE,FALSE,0);

	gtk_notebook_append_page(GTK_NOTEBOOK(sd->notebook),vbox,NULL);
}

static void create_nb_createGroupResult(struct search_dialog *sd)
{
	GtkWidget *vbox, *label;
	
	vbox = gtk_vbox_new(FALSE,8);
	label=gtk_label_new("");
	sd->create_group_result_info_label = label;
	gtk_misc_set_alignment (GTK_MISC (label), 0, .5);
	gtk_box_pack_start(GTK_BOX(vbox),label,FALSE,FALSE,0);

	gtk_notebook_append_page(GTK_NOTEBOOK(sd->notebook),vbox,NULL);
}

static void
on_add_friend_send_button_clicked (GtkWidget * widget, struct search_dialog *sd)
{
	gchar *reason,*str,*domain;
	const gchar *who;
	uint32 uin;	
	GtkTextIter start, end;
	
	gtk_text_buffer_get_bounds(gtk_text_view_get_buffer(GTK_TEXT_VIEW(sd->add_friend_textview)),&start,&end);
	str = gtk_text_buffer_get_text(gtk_text_view_get_buffer(GTK_TEXT_VIEW(sd->add_friend_textview)),&start,&end,FALSE);
	reason = g_locale_from_utf8(str,-1,NULL,NULL,NULL);
	g_free(str);
	who = gtk_label_get_text(GTK_LABEL(sd->add_friend_uin_label));
	uin = atol(who);
	domain = strchr(who,'@');
	if (domain)
		domain++;
	myicq_send_packet_msg(MSG_AUTH_REQUEST,uin, domain, reason,sd->gc);
	g_free(reason);
	gtk_label_set_text(GTK_LABEL(sd->add_friend_info_label),_("your request is already send,you can exit now."));
	gtk_widget_set_sensitive(sd->add_friend_hbox,FALSE);
}

static void create_nb_addFriend(struct search_dialog *sd)
{
	GtkWidget *vbox, *label, *vbox1, *hbox, *frame, *text, *scrolled_window, *button,*image;
	gchar str[256];
	
	vbox = gtk_vbox_new(FALSE,8);
	frame = gtk_frame_new(_("Add"));
	vbox1 = gtk_vbox_new(FALSE,5);
	image = gtk_image_new();
	sd->add_friend_image=image;
	gtk_box_pack_start(GTK_BOX(vbox1),image,FALSE,FALSE,0);
	label=gtk_label_new("");
	sd->add_friend_uin_label=label;
	gtk_box_pack_start(GTK_BOX(vbox1),label,FALSE,FALSE,0);
	label=gtk_label_new("");
	sd->add_friend_nick_label=label;
	gtk_box_pack_start(GTK_BOX(vbox1),label,FALSE,FALSE,5);

	gtk_container_add(GTK_CONTAINER(frame),vbox1);
	gtk_box_pack_start(GTK_BOX(vbox),frame,TRUE,TRUE,0);
	
	frame = gtk_frame_new(_("Please wait"));
	vbox1 = gtk_vbox_new(FALSE,8);
	label=gtk_label_new("");
	sd->add_friend_info_label=label;
	gtk_misc_set_alignment (GTK_MISC (label), 0, .5);
	gtk_box_pack_start(GTK_BOX(vbox1),label,FALSE,FALSE,0);
	
	hbox = gtk_hbox_new(FALSE,8);
	sd->add_friend_hbox = hbox;
	
	text = gtk_text_view_new();
	sd->add_friend_textview=text;
	gtk_widget_set_size_request (text, -1, 50);
	sprintf(str,_("I am %s (%s),can i make friend with you?"),sd->gc->username,sd->gc->displayname);
	gtk_text_buffer_set_text(gtk_text_view_get_buffer(GTK_TEXT_VIEW(text)),str,-1);

	scrolled_window = gtk_scrolled_window_new(NULL,NULL);
	gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (scrolled_window),
					GTK_POLICY_AUTOMATIC,
					GTK_POLICY_AUTOMATIC);
	gtk_container_add(GTK_CONTAINER(scrolled_window),text);
	gtk_scrolled_window_set_shadow_type (GTK_SCROLLED_WINDOW (scrolled_window), GTK_SHADOW_IN);
	gtk_text_view_set_left_margin (GTK_TEXT_VIEW (text), 2);
	gtk_text_view_set_right_margin (GTK_TEXT_VIEW (text), 2);
	gtk_box_pack_start(GTK_BOX(hbox),scrolled_window,TRUE,TRUE,0);
	
	button = gtk_button_new_with_label(_("Send"));
	g_signal_connect (G_OBJECT (button), "clicked",
			    G_CALLBACK(on_add_friend_send_button_clicked), sd);
	gtk_box_pack_start(GTK_BOX(hbox),button,FALSE,FALSE,0);
	
	gtk_box_pack_start(GTK_BOX(vbox1),hbox,FALSE,FALSE,0);

	gtk_container_add(GTK_CONTAINER(frame),vbox1);
	gtk_box_pack_start(GTK_BOX(vbox),frame,TRUE,TRUE,0);

	gtk_notebook_append_page(GTK_NOTEBOOK(sd->notebook),vbox,NULL);
}

static void
on_user_list_detail_button_clicked (GtkWidget * widget, struct search_dialog *sd)
{	
	GtkTreeModel *model;
	GtkTreeIter iter;
	
	if (gtk_tree_selection_get_selected (gtk_tree_view_get_selection (GTK_TREE_VIEW (sd->user_list_treeview)), &model, &iter))
	{
		gchar *bud;
		if (sd->nb_choose_radio == NB_CHOOSE_RADIO_MYICQ_NUM)
		{
			bud = g_strdup(gtk_entry_get_text(GTK_ENTRY(sd->myicq_num_entry)));
		}
		else if (sd->nb_choose_radio == NB_CHOOSE_RADIO_REMOTE_FRIEND)
		{
			GtkTreeModel *serv_list_model;
			GtkTreeIter serv_list_iter;	
			if (gtk_tree_selection_get_selected (gtk_tree_view_get_selection (GTK_TREE_VIEW (sd->server_list_treeview)), &serv_list_model, &serv_list_iter))
			{
				gchar *domain;
				gchar *uin;
				gtk_tree_model_get (serv_list_model, &serv_list_iter,0,&domain,-1);						
				gtk_tree_model_get (model, &iter,1, &uin,-1);
				bud = g_strdup_printf("%s@%s",uin,domain);
				g_free(domain);
				g_free(uin);
			}			
		}
		else			
		{			
			gtk_tree_model_get (model, &iter,1, &bud,-1);
		}
		myicq_get_info(sd->gc,bud);
		g_free(bud);
	}
}

static gboolean
on_user_list_button_press(GtkWidget * widget, GdkEventButton * event,
			   struct search_dialog *sd)
{
	if (event->type==GDK_2BUTTON_PRESS)
	{
		on_user_list_detail_button_clicked(sd->user_list_detail_button,sd);
		return TRUE;
	}
	else
	{
		return FALSE;
	}
}

static void
on_user_list_previous_button_clicked (GtkWidget * widget, struct search_dialog *sd)
{
	if (sd->search_user_result_current_page == -1) // all pages
		search_dialog_refresh_search_user_result(sd, 0); //show first page.
	else
		search_dialog_refresh_search_user_result(sd, sd->search_user_result_current_page-1);
}

static void
on_user_list_next_button_clicked (GtkWidget * widget, struct search_dialog *sd)
{
	gint total_page;
	total_page = g_slist_length(sd->search_user_result_page_list);
	if (sd->nb_choose_radio == NB_CHOOSE_RADIO_RANDOM_SEARCH)
	{
		if ((sd->search_user_result_current_page == -1)||(sd->search_user_result_current_page == total_page-1))
		{
			gtk_label_set_text(GTK_LABEL(sd->user_list_info_label),_("Searching..."));
			gtk_widget_set_sensitive(sd->user_list_previous_button,FALSE);
			gtk_widget_set_sensitive(sd->user_list_next_button,FALSE);
			gtk_widget_set_sensitive(sd->user_list_all_button,FALSE);
			myicq_send_packet_searchRandom(NULL,sd->gc);	
		}		
		else
		{
			search_dialog_refresh_search_user_result(sd, sd->search_user_result_current_page+1);
		}
	}
	else if (sd->nb_choose_radio == NB_CHOOSE_RADIO_REMOTE_FRIEND)
	{
		if ((sd->search_user_result_current_page == -1)||(sd->search_user_result_current_page == total_page-1))
		{
			GtkTreeModel *serv_list_model;
			GtkTreeIter serv_list_iter;	
			
			if (gtk_tree_selection_get_selected (gtk_tree_view_get_selection (GTK_TREE_VIEW (sd->server_list_treeview)), &serv_list_model, &serv_list_iter))
			{
				gchar *domain;
				gtk_tree_model_get (serv_list_model, &serv_list_iter,0,&domain,-1);						

				gtk_label_set_text(GTK_LABEL(sd->user_list_info_label),_("Searching..."));
				gtk_widget_set_sensitive(sd->user_list_previous_button,FALSE);
				gtk_widget_set_sensitive(sd->user_list_next_button,FALSE);
				gtk_widget_set_sensitive(sd->user_list_all_button,FALSE);
				myicq_send_packet_searchRandom(domain,sd->gc);	
				g_free(domain);
			}			
		}		
		else
		{
			search_dialog_refresh_search_user_result(sd, sd->search_user_result_current_page+1);
		}
	}
	else if (sd->nb_choose_radio == NB_CHOOSE_RADIO_MYICQ_NUM)
	{
		if (sd->search_user_result_current_page == -1)
		{
			search_dialog_refresh_search_user_result(sd, total_page-1);
		}
		else if(sd->search_user_result_current_page == total_page-1)
		{
		}
		else
		{
			search_dialog_refresh_search_user_result(sd, sd->search_user_result_current_page+1);
		}
	}
	else if (sd->nb_choose_radio == NB_CHOOSE_RADIO_CUSTOM_SEARCH)
	{
		if ((sd->search_user_result_current_page == -1)||(sd->search_user_result_current_page == total_page-1))
		{
			if (sd->customSearch_startUIN!=-1) //if equal -1,then the last search get no result,needn't search again.
			{
				gtk_label_set_text(GTK_LABEL(sd->user_list_info_label),_("Searching..."));
				gtk_widget_set_sensitive(sd->user_list_previous_button,FALSE);
				gtk_widget_set_sensitive(sd->user_list_next_button,FALSE);
				gtk_widget_set_sensitive(sd->user_list_all_button,FALSE);
				myicq_send_packet_searchCustom(gtk_entry_get_text(GTK_ENTRY(sd->search_custom_nick_entry)),gtk_entry_get_text(GTK_ENTRY(sd->search_custom_email_entry)),sd->customSearch_startUIN,sd->gc);			
			}
			else
			{
				search_dialog_refresh_search_user_result(sd, total_page-1);
			}
		}		
		else
		{
			search_dialog_refresh_search_user_result(sd, sd->search_user_result_current_page+1);
		}
	}
}

static void
on_user_list_all_button_clicked (GtkWidget * widget, struct search_dialog *sd)
{
	search_dialog_refresh_search_user_result(sd, -1); // -1 means all pages.
}

static void create_nb_userList(struct search_dialog *sd)
{
	GtkWidget *tree_view,*vbox,*hbox,*label,*button;
	GtkWidget *sw;
	GtkListStore *model;
	gint col_offset;
	GtkCellRenderer *renderer;
	GtkCellRenderer *renderer_image;
	GtkCellRenderer *renderer_text;
	GtkTreeViewColumn *column;

	vbox = gtk_vbox_new(FALSE,8);
	
	model = gtk_list_store_new (5,GDK_TYPE_PIXBUF,G_TYPE_STRING,G_TYPE_STRING,G_TYPE_STRING,G_TYPE_INT);
	tree_view = gtk_tree_view_new_with_model (GTK_TREE_MODEL (model));
	sd->user_list_treeview = tree_view;
	g_object_unref (model);
		  
	renderer_image = gtk_cell_renderer_pixbuf_new();
	renderer_text = gtk_cell_renderer_text_new ();
	column = gtk_tree_view_column_new();
	gtk_tree_view_column_set_title(column,_("Myicq number"));
	gtk_tree_view_column_pack_start(column,renderer_image,FALSE);
	gtk_tree_view_column_add_attribute(column,
                                     renderer_image,
                                     "pixbuf",0);
	gtk_tree_view_column_pack_end(column,renderer_text,TRUE);
	gtk_tree_view_column_add_attribute(column,
                                     renderer_text,
                                     "text",1);
	gtk_tree_view_insert_column(GTK_TREE_VIEW(tree_view),column,-1);



	renderer = gtk_cell_renderer_text_new ();
	g_object_set (G_OBJECT (renderer), "xalign", 0.0, NULL);
	col_offset = gtk_tree_view_insert_column_with_attributes (GTK_TREE_VIEW (tree_view),
							    -1, _("Nick name"),
							    renderer, "text",
							    2,
							    NULL);
	column = gtk_tree_view_get_column (GTK_TREE_VIEW (tree_view), col_offset - 1);
	gtk_tree_view_column_set_clickable (GTK_TREE_VIEW_COLUMN (column), TRUE);

	renderer = gtk_cell_renderer_text_new ();
	g_object_set (G_OBJECT (renderer), "xalign", 0.0, NULL);
	col_offset = gtk_tree_view_insert_column_with_attributes (GTK_TREE_VIEW (tree_view),
							    -1, _("Province"),
							    renderer, "text",
							    3,
							    NULL);

	g_signal_connect (G_OBJECT (tree_view),
			"button_press_event",
			G_CALLBACK (on_user_list_button_press),
			sd);
	sw = gtk_scrolled_window_new (NULL, NULL);
	gtk_scrolled_window_set_shadow_type (GTK_SCROLLED_WINDOW (sw),GTK_SHADOW_ETCHED_IN);
	gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (sw),GTK_POLICY_AUTOMATIC,GTK_POLICY_AUTOMATIC);	
	gtk_container_add (GTK_CONTAINER (sw), tree_view);
	
	gtk_box_pack_start(GTK_BOX(vbox),sw,TRUE,TRUE,0);
	hbox = gtk_hbox_new(FALSE,8);
	label= gtk_label_new("");
	sd->user_list_info_label = label;
	gtk_box_pack_start(GTK_BOX(hbox),label,FALSE,FALSE,0);
	button = gtk_button_new_with_label(_("Previous page"));
	sd->user_list_previous_button = button;
	g_signal_connect (G_OBJECT (button), "clicked",
			    G_CALLBACK(on_user_list_previous_button_clicked), sd);
	gtk_box_pack_start(GTK_BOX(hbox),button,FALSE,FALSE,0);
	button = gtk_button_new_with_label(_("Next page"));
	sd->user_list_next_button = button;
	g_signal_connect (G_OBJECT (button), "clicked",
			    G_CALLBACK(on_user_list_next_button_clicked), sd);
	gtk_box_pack_start(GTK_BOX(hbox),button,FALSE,FALSE,0);
	button = gtk_button_new_with_label(_("Detail"));
	sd->user_list_detail_button = button;
	g_signal_connect (G_OBJECT (button), "clicked",
			    G_CALLBACK(on_user_list_detail_button_clicked), sd);
	gtk_box_pack_start(GTK_BOX(hbox),button,FALSE,FALSE,0);
	button = gtk_button_new_with_label(_("All pages"));
	g_signal_connect (G_OBJECT (button), "clicked",
			    G_CALLBACK(on_user_list_all_button_clicked), sd);
	sd->user_list_all_button = button;
	gtk_box_pack_start(GTK_BOX(hbox),button,FALSE,FALSE,0);
	gtk_box_pack_start(GTK_BOX(vbox),hbox,FALSE,FALSE,0);

	gtk_notebook_append_page(GTK_NOTEBOOK(sd->notebook),vbox,NULL);
}

static gboolean
on_server_list_button_press(GtkWidget * widget, GdkEventButton * event,
			   struct search_dialog *sd)
{
	if (event->type==GDK_2BUTTON_PRESS)
	{
		search_dialog_next(widget,sd);
		return TRUE;
	}
	else
	{
		return FALSE;
	}
}

static void create_nb_serverList(struct search_dialog *sd)
{
	GtkWidget *tree_view,*vbox,*label;
	GtkWidget *sw;
	GtkListStore *model;
	gint col_offset;
	GtkCellRenderer *renderer;

	vbox = gtk_vbox_new(FALSE,8);
	
	model = gtk_list_store_new (3,G_TYPE_STRING,G_TYPE_INT,G_TYPE_STRING);
	tree_view = gtk_tree_view_new_with_model (GTK_TREE_MODEL (model));
	sd->server_list_treeview = tree_view;
	g_object_unref (model);
		  
	renderer = gtk_cell_renderer_text_new ();
	g_object_set (G_OBJECT (renderer), "xalign", 0.0, NULL);
	col_offset = gtk_tree_view_insert_column_with_attributes (GTK_TREE_VIEW (tree_view),
							    -1, _("MyICQ Server"),
							    renderer, "text",
							    0,
							    NULL);

	renderer = gtk_cell_renderer_text_new ();
	g_object_set (G_OBJECT (renderer), "xalign", 0.0, NULL);
	col_offset = gtk_tree_view_insert_column_with_attributes (GTK_TREE_VIEW (tree_view),
							    -1, _("Online user count"),
							    renderer, "text",
							    1,
							    NULL);

	renderer = gtk_cell_renderer_text_new ();
	g_object_set (G_OBJECT (renderer), "xalign", 0.0, NULL);
	col_offset = gtk_tree_view_insert_column_with_attributes (GTK_TREE_VIEW (tree_view),
							    -1, _("Description"),
							    renderer, "text",
							    2,
							    NULL);

	g_signal_connect (G_OBJECT (tree_view),
			"button_press_event",
			G_CALLBACK (on_server_list_button_press),
			sd);
	sw = gtk_scrolled_window_new (NULL, NULL);
	gtk_scrolled_window_set_shadow_type (GTK_SCROLLED_WINDOW (sw),GTK_SHADOW_ETCHED_IN);
	gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (sw),GTK_POLICY_AUTOMATIC,GTK_POLICY_AUTOMATIC);	
	gtk_container_add (GTK_CONTAINER (sw), tree_view);
	
	gtk_box_pack_start(GTK_BOX(vbox),sw,TRUE,TRUE,0);

	label= gtk_label_new(_("Reading the server list..."));
	sd->server_list_label = label;
	gtk_box_pack_start(GTK_BOX(vbox),label,FALSE,FALSE,0);

	gtk_notebook_append_page(GTK_NOTEBOOK(sd->notebook),vbox,NULL);
}

static gboolean
on_group_type_list_button_press(GtkWidget * widget, GdkEventButton * event,
			   struct search_dialog *sd)
{
	if (event->type==GDK_2BUTTON_PRESS)
	{
		search_dialog_next(widget,sd);
		return TRUE;
	}
	else
	{
		return FALSE;
	}
}

static void create_nb_groupTypeList(struct search_dialog *sd)
{
	struct myicq_data *md = sd->gc->proto_data;
	GtkWidget *tree_view,*vbox,*label;
	GtkWidget *sw;
	GtkListStore *model;
	GtkTreeIter iter;
	gint col_offset;
	GtkCellRenderer *renderer;
	GSList *grouptype_list;
	struct serv_group_type *grouptype;
	gint type_index = 0;

	vbox = gtk_vbox_new(FALSE,8);

	label= gtk_label_new(_("Please choose the group type."));
	gtk_box_pack_start(GTK_BOX(vbox),label,FALSE,FALSE,0);
	
	model = gtk_list_store_new (3,G_TYPE_STRING,G_TYPE_STRING,G_TYPE_INT);
	grouptype_list = md->servgrouptype;
	while (grouptype_list)
	{
		grouptype = (struct serv_group_type *)(grouptype_list->data);
		gtk_list_store_append (model, &iter);
		gtk_list_store_set (model, &iter,
				0,grouptype->displayname,
				1,grouptype->name,
				2,type_index,
				-1);
		type_index++;
		grouptype_list = g_slist_next(grouptype_list);
	}
		
	tree_view = gtk_tree_view_new_with_model (GTK_TREE_MODEL (model));
	sd->group_type_list_treeview = tree_view;
	g_object_unref (model);
		  
	renderer = gtk_cell_renderer_text_new ();
	g_object_set (G_OBJECT (renderer), "xalign", 0.0, NULL);
	col_offset = gtk_tree_view_insert_column_with_attributes (GTK_TREE_VIEW (tree_view),
							    -1, _("Group Type"),
							    renderer, "text",
							    0,
							    NULL);

	renderer = gtk_cell_renderer_text_new ();
	g_object_set (G_OBJECT (renderer), "xalign", 0.0, NULL);
	col_offset = gtk_tree_view_insert_column_with_attributes (GTK_TREE_VIEW (tree_view),
							    -1, _("Plug-in"),
							    renderer, "text",
							    1,
							    NULL);

	g_signal_connect (G_OBJECT (tree_view),
			"button_press_event",
			G_CALLBACK (on_group_type_list_button_press),
			sd);
	sw = gtk_scrolled_window_new (NULL, NULL);
	gtk_scrolled_window_set_shadow_type (GTK_SCROLLED_WINDOW (sw),GTK_SHADOW_ETCHED_IN);
	gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (sw),GTK_POLICY_AUTOMATIC,GTK_POLICY_AUTOMATIC);	
	gtk_container_add (GTK_CONTAINER (sw), tree_view);
	
	gtk_box_pack_start(GTK_BOX(vbox),sw,TRUE,TRUE,0);

	gtk_notebook_append_page(GTK_NOTEBOOK(sd->notebook),vbox,NULL);
}

static gboolean
on_group_list_button_press(GtkWidget * widget, GdkEventButton * event,
			   struct search_dialog *sd)
{
	if (event->type==GDK_2BUTTON_PRESS)
	{
		search_dialog_next(widget,sd);
		return TRUE;
	}
	else
	{
		return FALSE;
	}
}

static void create_nb_groupList(struct search_dialog *sd)
{
	GtkWidget *tree_view,*vbox,*hbox,*label,*entry;
	GtkWidget *sw;
	GtkListStore *model;
	gint col_offset;
	GtkCellRenderer *renderer;

	vbox = gtk_vbox_new(FALSE,8);
	
	model = gtk_list_store_new (3,G_TYPE_INT,G_TYPE_STRING,G_TYPE_INT); //id,name,num
	tree_view = gtk_tree_view_new_with_model (GTK_TREE_MODEL (model));
	sd->group_list_treeview = tree_view;
	g_object_unref (model);
		  
	renderer = gtk_cell_renderer_text_new ();
	g_object_set (G_OBJECT (renderer), "xalign", 0.0, NULL);
	col_offset = gtk_tree_view_insert_column_with_attributes (GTK_TREE_VIEW (tree_view),
							    -1, _("Group ID"),
							    renderer, "text",
							    0,
							    NULL);

	renderer = gtk_cell_renderer_text_new ();
	g_object_set (G_OBJECT (renderer), "xalign", 0.0, NULL);
	col_offset = gtk_tree_view_insert_column_with_attributes (GTK_TREE_VIEW (tree_view),
							    -1, _("Group name"),
							    renderer, "text",
							    1,
							    NULL);

	renderer = gtk_cell_renderer_text_new ();
	g_object_set (G_OBJECT (renderer), "xalign", 0.0, NULL);
	col_offset = gtk_tree_view_insert_column_with_attributes (GTK_TREE_VIEW (tree_view),
							    -1, _("Member count"),
							    renderer, "text",
							    2,
							    NULL);

	g_signal_connect (G_OBJECT (tree_view),
			"button_press_event",
			G_CALLBACK (on_group_list_button_press),
			sd);
	sw = gtk_scrolled_window_new (NULL, NULL);
	gtk_scrolled_window_set_shadow_type (GTK_SCROLLED_WINDOW (sw),GTK_SHADOW_ETCHED_IN);
	gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (sw),GTK_POLICY_AUTOMATIC,GTK_POLICY_AUTOMATIC);	
	gtk_container_add (GTK_CONTAINER (sw), tree_view);
	
	gtk_box_pack_start(GTK_BOX(vbox),sw,TRUE,TRUE,0);

	label= gtk_label_new("");
	sd->group_list_info_label = label;
	gtk_box_pack_start(GTK_BOX(vbox),label,FALSE,FALSE,0);

	hbox = gtk_hbox_new(FALSE,8);
	label= gtk_label_new(_("Password:"));
	gtk_box_pack_start(GTK_BOX(hbox),label,FALSE,FALSE,0);
	entry = gtk_entry_new();
	sd->group_list_password_entry = entry;
	g_signal_connect (G_OBJECT (entry), "activate",
				    G_CALLBACK(search_dialog_next), sd);
	gtk_box_pack_start(GTK_BOX(hbox),entry,FALSE,FALSE,0);
	gtk_box_pack_start(GTK_BOX(vbox),hbox,FALSE,FALSE,0);

	gtk_notebook_append_page(GTK_NOTEBOOK(sd->notebook),vbox,NULL);
}

static GtkWidget *
create_notebook(struct search_dialog *sd)
{
	GtkWidget *nb;

	nb = gtk_notebook_new();
	sd->notebook = nb;
	gtk_notebook_set_show_tabs(GTK_NOTEBOOK(nb),FALSE);
	gtk_notebook_set_show_border(GTK_NOTEBOOK(nb),FALSE);
	create_nb_choose(sd);
	create_nb_myicqNum(sd);
	create_nb_customSearch(sd);
	create_nb_userList(sd);
	create_nb_addFriend(sd);
	create_nb_serverList(sd);
	create_nb_groupTypeList(sd);
	create_nb_groupList(sd);
	create_nb_groupNUm(sd);
	create_nb_createGroup(sd);
	create_nb_createGroupResult(sd);
	gtk_notebook_set_current_page (GTK_NOTEBOOK (nb), NB_CHOOSE);
	sd->nb_current_page = NB_CHOOSE;	
	
	return nb;
}

void
myicq_show_search_dialog(struct gaim_connection *gc)
{
	struct myicq_data *md = gc->proto_data;
	
	if (md->searchDlg)
	{
		gtk_window_present(GTK_WINDOW(md->searchDlg->window));
		return;
	}
	else
	{
		GtkWidget *window,*button,*vbox,*hbox,*separator;
		struct search_dialog *sd;
		
		md->searchDlg = g_new0(struct search_dialog,1);
		sd = md->searchDlg;
		sd->gc = gc;	
		
		window = gtk_window_new(GTK_WINDOW_TOPLEVEL);
		sd->window = window;	
	
		g_signal_connect (G_OBJECT (window), "delete_event",
				    G_CALLBACK(search_window_deleteevent), NULL);
		g_signal_connect (G_OBJECT (window), "destroy",
			    G_CALLBACK(search_dialog_destroy), sd);
		gtk_window_set_resizable (GTK_WINDOW (window), FALSE);
		gtk_window_set_title (GTK_WINDOW (window), _("Search"));
		gtk_container_set_border_width (GTK_CONTAINER (window), 8);

		vbox = gtk_vbox_new(FALSE,0);
		gtk_container_add (GTK_CONTAINER (window), vbox);

		gtk_box_pack_start(GTK_BOX(vbox),create_notebook(sd),FALSE,FALSE,10);
		separator = gtk_hseparator_new ();
		gtk_box_pack_start (GTK_BOX (vbox), separator, FALSE, TRUE, 10);

					
		hbox = gtk_hbox_new(FALSE,10);
		button = gtk_button_new_with_label(_("< Back"));
		sd->back_button = button;		
		gtk_widget_set_sensitive(button,FALSE);
		gtk_box_pack_start_defaults(GTK_BOX(hbox),button);
		g_signal_connect (G_OBJECT (button), "clicked",
			    G_CALLBACK(search_dialog_back), sd);
		button = gtk_button_new_with_label(_("Next >"));
		sd->next_button = button;
		gtk_box_pack_start_defaults(GTK_BOX(hbox),button);
		g_signal_connect (G_OBJECT (button), "clicked",
			    G_CALLBACK(search_dialog_next), sd);
		button = gtk_button_new_with_label(_("Cancel"));
		sd->cancel_button = button;
		g_signal_connect (G_OBJECT (button), "clicked",
				    G_CALLBACK(search_dialog_cancel), sd);
		gtk_box_pack_start_defaults(GTK_BOX(hbox),button);
		gtk_box_pack_start_defaults(GTK_BOX(vbox),hbox);
	
		gtk_widget_show_all(window);
	}
}
