/*
 * GTK See -- an image viewer based on GTK+
 * Copyright (C) 1998 Hotaru Lee <jkhotaru@mail.sti.com.cn> <hotaru@163.net>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

/*
 * 20-06-2004: Functions for Dialog window
 * Based in dialog.c of qiv
 */
#include "config.h"

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <time.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <gtk/gtk.h>

#include "intl.h"
#include "dialog.h"
#include "pixmaps/delete_dialog.xpm"
#include "pixmaps/error_dialog.xpm"
#include "pixmaps/favorites_dialog.xpm"
#include "pixmaps/question_dialog.xpm"
#include "pixmaps/rename_dialog.xpm"
#include "pixmaps/warning_dialog.xpm"

/* Begin the code ... */

void
dialog_ok_button(GtkWidget *widget, gint *data)
{
   *data = OK_STATUS;
   gtk_main_quit();

   return;
}

void
dialog_cancel_button(GtkWidget *widget, gint *data)
{
   *data = CANCEL_STATUS;
   gtk_main_quit();

   return;
}


void
dialog_all_button(GtkWidget *widget, gint *data)
{
   *data = ALL_STATUS;
   gtk_main_quit();

   return;
}

DialogStatus
dialog_message(GtkWidget    *parentwindow,
               gchar        *title,
               gchar        *msg,
               gchar        *msguser,
               DialogType   type,
               DialogPixmap pixmaptype,
               gboolean     useentry,
               gchar        **str,
               gint         maxlen)
{
   GtkWidget   *dialog;
   GtkWidget   *vbox, *hbox;
   GtkWidget   *label;
   GtkWidget   *button_box;
   GtkWidget   *button;
   GtkWidget   *entry;
   GdkBitmap   *mask;
   GdkPixmap   *pixmap;
   GtkWidget   *pmwidget;
   DialogStatus status;

   dialog = gtk_dialog_new();
   gtk_window_set_title (GTK_WINDOW(dialog), title);
   gtk_window_set_policy(GTK_WINDOW(dialog), FALSE, FALSE, FALSE);
   gtk_window_set_position(GTK_WINDOW(dialog), GTK_WIN_POS_CENTER);
   gtk_container_border_width(GTK_CONTAINER(dialog), 5);
   gtk_signal_connect(GTK_OBJECT(dialog), "delete_event",
                     GTK_SIGNAL_FUNC(dialog_cancel_button),
                     NULL);
   gtk_widget_realize(dialog);

   hbox = gtk_hbox_new(FALSE, 20);
   gtk_container_border_width(GTK_CONTAINER(hbox), 15);
   gtk_box_pack_start(GTK_BOX(GTK_DIALOG(dialog)->vbox), hbox, TRUE, TRUE, 0);

   switch(pixmaptype)
   {
      case DELETE_DIALOG:
         pixmap= gdk_pixmap_create_from_xpm_d(dialog->window,
                           &mask, NULL, (gchar **)delete_dialog_xpm);
         break;

      case ERROR_DIALOG:
         pixmap= gdk_pixmap_create_from_xpm_d(dialog->window,
                           &mask, NULL, (gchar **)error_dialog_xpm);
         break;

      case FAVORITES_DIALOG:
         pixmap= gdk_pixmap_create_from_xpm_d(dialog->window,
                           &mask, NULL, (gchar **)favorites_dialog_xpm);
         break;

      case QUESTION_DIALOG:
         pixmap= gdk_pixmap_create_from_xpm_d(dialog->window,
                           &mask, NULL, (gchar **)question_dialog_xpm);
         break;

      case RENAME_DIALOG:
         pixmap= gdk_pixmap_create_from_xpm_d(dialog->window,
                           &mask, NULL, (gchar **)rename_dialog_xpm);
         break;

      case WARNING_DIALOG:
         pixmap= gdk_pixmap_create_from_xpm_d(dialog->window,
                           &mask, NULL, (gchar **)warning_dialog_xpm);
         break;
   }

   pmwidget = gtk_pixmap_new(pixmap, mask);

   gtk_box_pack_start(GTK_BOX(hbox), pmwidget, FALSE, FALSE, 0);

   vbox = gtk_vbox_new(TRUE, 2);
   gtk_box_pack_end(GTK_BOX(hbox), vbox, TRUE, TRUE, 0);

   if (msg != NULL)
   {
      label = gtk_label_new(msg);
      gtk_box_pack_start(GTK_BOX(vbox), label, TRUE, TRUE, 0);
   }

   if (msguser != NULL)
   {
      label = gtk_label_new(msguser);
      gtk_box_pack_start(GTK_BOX(vbox), label, TRUE, TRUE, 0);
   }

   /* Dialog have a text widget ? */
   if (useentry == TRUE)
   {
      entry = gtk_entry_new();
      if (maxlen)
      {
         gtk_entry_set_max_length(GTK_ENTRY(entry), maxlen);
      } else
      {
         gtk_entry_set_max_length(GTK_ENTRY(entry), 128);
      }
      gtk_box_pack_start(GTK_BOX(vbox), entry, TRUE, TRUE, 0);
   }

   /* Select the buttons */
   button_box = gtk_hbutton_box_new();
   gtk_button_box_set_layout(GTK_BUTTON_BOX(button_box), GTK_BUTTONBOX_SPREAD);
   gtk_box_pack_start(GTK_BOX(GTK_DIALOG(dialog)->action_area),
                        button_box, TRUE, TRUE, 0);
   gtk_widget_show(button_box);

   button = gtk_button_new_with_label(_("OK"));
   gtk_box_pack_end(GTK_BOX(button_box), button, FALSE, FALSE, 0);
   gtk_signal_connect(GTK_OBJECT(button), "clicked",
                        GTK_SIGNAL_FUNC(dialog_ok_button), &status);
   GTK_WIDGET_SET_FLAGS(button, GTK_CAN_DEFAULT);
   gtk_widget_grab_default(button);
   gtk_widget_grab_focus(button);

   if (type == OK_CANCEL_ALL_DIALOG ||
       type == OK_CANCEL_DIALOG)
   {
      button = gtk_button_new_with_label(_("Cancel"));
      gtk_box_pack_end(GTK_BOX(button_box), button, FALSE, FALSE, 0);
      gtk_signal_connect(GTK_OBJECT(button), "clicked",
                         GTK_SIGNAL_FUNC(dialog_cancel_button), &status);
      GTK_WIDGET_SET_FLAGS(button, GTK_CAN_DEFAULT);
   }

   if (type == OK_CANCEL_ALL_DIALOG)
   {
      button = gtk_button_new_with_label(_("Apply All"));
      gtk_box_pack_end(GTK_BOX(button_box), button, FALSE, FALSE, 0);
      gtk_signal_connect(GTK_OBJECT(button), "clicked",
                         GTK_SIGNAL_FUNC(dialog_all_button), &status);
      GTK_WIDGET_SET_FLAGS(button, GTK_CAN_DEFAULT);
   }

   gtk_widget_show_all(dialog);
   if (GTK_IS_WINDOW(dialog))
   {
      gdk_window_raise(dialog->window);
   }

   gtk_window_set_modal(GTK_WINDOW(dialog), TRUE);
   gtk_grab_add(GTK_WIDGET(dialog));

   if((parentwindow != NULL) ?
         GTK_IS_WINDOW(GTK_OBJECT(parentwindow)) : FALSE)
   {
      gtk_window_set_transient_for(GTK_WINDOW(dialog),
                                    GTK_WINDOW(parentwindow));
   }

   gtk_main();

   if (useentry == TRUE &&
         (status == OK_STATUS ||
          status == ALL_STATUS  ))
   {
      *str = gtk_editable_get_chars(GTK_EDITABLE(entry), 0, -1);
      if (strlen(*str) == 0)
      {
         status = CANCEL_STATUS;
      }

   }

   gtk_grab_remove(GTK_WIDGET(dialog));
   gtk_window_set_modal(GTK_WINDOW(dialog), FALSE);
   gtk_window_set_transient_for(GTK_WINDOW(dialog), NULL);
   gtk_widget_destroy(dialog);

   return status;
}

DialogStatus
dialog_color(GtkWidget *parentwindow, gchar *title, gint *newcolor)
{
   GtkWidget   *dialog;
   GtkWidget   *color_selector;
   GtkWidget   *button_box;
   GtkWidget   *button;
   DialogStatus status;

   dialog = gtk_dialog_new();
   gtk_window_set_title (GTK_WINDOW(dialog), title);
   gtk_window_set_policy(GTK_WINDOW(dialog), FALSE, FALSE, FALSE);
   gtk_window_set_position(GTK_WINDOW(dialog), GTK_WIN_POS_CENTER);
   gtk_container_border_width(GTK_CONTAINER(dialog), 5);
   gtk_signal_connect(GTK_OBJECT(dialog), "delete_event",
                     GTK_SIGNAL_FUNC(dialog_cancel_button),
                     NULL);
   gtk_widget_realize(dialog);

   color_selector = gtk_color_selection_new();
   gtk_widget_show(color_selector);
   gtk_box_pack_start(GTK_BOX(GTK_DIALOG(dialog)->vbox), color_selector, TRUE, TRUE, 0);

   /* Select the buttons */
   button_box = gtk_hbutton_box_new();
   gtk_button_box_set_layout(GTK_BUTTON_BOX(button_box), GTK_BUTTONBOX_SPREAD);
   gtk_box_pack_start(GTK_BOX(GTK_DIALOG(dialog)->action_area),
                        button_box, TRUE, TRUE, 0);
   gtk_widget_show(button_box);

   button = gtk_button_new_with_label(_("OK"));
   gtk_box_pack_end(GTK_BOX(button_box), button, FALSE, FALSE, 0);
   gtk_signal_connect(GTK_OBJECT(button), "clicked",
                        GTK_SIGNAL_FUNC(dialog_ok_button), &status);
   GTK_WIDGET_SET_FLAGS(button, GTK_CAN_DEFAULT);
   gtk_widget_grab_default(button);
   gtk_widget_grab_focus(button);

   button = gtk_button_new_with_label(_("Cancel"));
   gtk_box_pack_end(GTK_BOX(button_box), button, FALSE, FALSE, 0);
   gtk_signal_connect(GTK_OBJECT(button), "clicked",
                         GTK_SIGNAL_FUNC(dialog_cancel_button), &status);
   GTK_WIDGET_SET_FLAGS(button, GTK_CAN_DEFAULT);

   gtk_widget_show_all(dialog);
   if (GTK_IS_WINDOW(dialog))
   {
      gdk_window_raise(dialog->window);
   }

   gtk_window_set_modal(GTK_WINDOW(dialog), TRUE);
   gtk_grab_add(GTK_WIDGET(dialog));

   if((parentwindow != NULL) ?
         GTK_IS_WINDOW(GTK_OBJECT(parentwindow)) : FALSE)
   {
      gtk_window_set_transient_for(GTK_WINDOW(dialog),
                                    GTK_WINDOW(parentwindow));
   }

   gtk_main();

   if (status == OK_STATUS)
   {
      gdouble color[4];

      gtk_color_selection_get_color(GTK_COLOR_SELECTION(color_selector), color);
      *newcolor = (gint) (((gint) (color[0] * 255.0) * 0x10000) |
                          ((gint) (color[1] * 255.0) * 0x100)   |
                           (gint) (color[2] * 255.0));
   }

   gtk_grab_remove(GTK_WIDGET(dialog));
   gtk_window_set_modal(GTK_WINDOW(dialog), FALSE);
   gtk_window_set_transient_for(GTK_WINDOW(dialog), NULL);
   gtk_widget_destroy(dialog);

   return status;
}
