/*
 * GTK See -- an image viewer based on GTK+
 * Copyright (C) 1998 Hotaru Lee <jkhotaru@mail.sti.com.cn> <hotaru@163.net>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

/* 2004-06-29: Based in Alias PIX File Format Information.
 *
 */

#include <stdio.h>
#include <stdlib.h>

#include "common_tools.h"
#include "im_pix.h"

guint16
pix_short (FILE *fd)
{
   guchar v[2];

   if (fread(v, 2, sizeof(guchar), fd) == EOF)
   {
      return 0;
   } else
   {
      return ((v[0] << 8) | v[1]);
   }

}

gboolean
pix_get_header(gchar *filename, pix_info *info)
{
   guint    w, h, b;
   gboolean status = TRUE;

   FILE     *fd;

   if ((fd = fopen (filename, "rb")) == NULL)
   {
      return FALSE;
   }

   if ((w = pix_short(fd)) == 0) status = FALSE;
   if ((h = pix_short(fd)) == 0) status = FALSE;

   pix_short(fd);
   pix_short(fd);

   if ((b = pix_short(fd)) == 0) status = FALSE;

   if (b != 0x18 && b != 0x08) status = FALSE;

   if (status)
   {
      info->width = w;
      info->height= h;
      info->bpp   = b;
   }

   fclose(fd);
   return status;
}

gboolean
pix_load (gchar *filename, PixLoadFunc func)
{
   FILE     *fd;
   pix_info pixhdr;
   guchar   *buffer;
   gint     i, j, k, counter;
   gboolean status = TRUE;
   guchar   pack[4];

   if (pix_get_header(filename, &pixhdr) == FALSE)
   {
      return FALSE;
   }


   if ((fd = fopen (filename, "rb")) == NULL)
   {
      return FALSE;
   }

   fseek(fd, 10, SEEK_SET);

   /* Format of PIX image:
    * 0 Run length - number of pixels in succession with given RGB.
    * 1 Blue component.
    * 2 Green component.
    * 3 Red component.
    */

   buffer = g_malloc(sizeof(guchar) * pixhdr.width * 3);

   for (i = 0; i < pixhdr.height; i++)
   {
      k = 0;
      for (j=0; j<pixhdr.width ;)
      {
         switch(pixhdr.bpp)
         {
            case 0x18:  /* RGB Pix image */
               if (fread (pack, 1, 4, fd) < 4)
               {
                  status = FALSE;
                  goto stop_pix;
               }

               for (counter=0; counter < pack[0]; counter++)
               {
                  buffer[k++] = pack[3];
                  buffer[k++] = pack[2];
                  buffer[k++] = pack[1];
                  if (++j >= pixhdr.width) break;
               }
               break;

            case 0x08:  /* GrayScale Pix image */
               if (fread (pack, 1, 2, fd) < 2)
               {
                  status = FALSE;
                  goto stop_pix;
               }

               for (counter=0; counter < pack[0]; counter++)
               {
                  buffer[k++] = pack[1];
                  buffer[k++] = pack[1];
                  buffer[k++] = pack[1];
                  if (++j >= pixhdr.width) break;
               }
               break;
            default:
               status = FALSE;
               goto stop_pix;
         }
      }
      if ((*func) (buffer, pixhdr.width, 0, i, 3, -1, 0)) break;
   }

stop_pix:
   g_free(buffer);
   fclose (fd);

   return status;
}

