/*
 * GTK See -- an image viewer based on GTK+
 * Copyright (C) 1998 Hotaru Lee <jkhotaru@mail.sti.com.cn> <hotaru@163.net>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "config.h"

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <gtk/gtk.h>

#include "common_tools.h"
#include "intl.h"
#include "rc.h"
#include "viewertoolbar.h"

#include "pixmaps/browse.xpm"
#include "pixmaps/exit.xpm"
#include "pixmaps/fullscreen.xpm"
#include "pixmaps/prev_image.xpm"
#include "pixmaps/next_image.xpm"
#include "pixmaps/save_image.xpm"
#include "pixmaps/slideshow.xpm"
#include "pixmaps/screen.xpm"
#include "pixmaps/rotate_left.xpm"
#include "pixmaps/rotate_right.xpm"
#include "pixmaps/refresh.xpm"
#include "pixmaps/right_left.xpm"
#include "pixmaps/up_down.xpm"

GtkWidget *prev_button, *next_button;
GtkWidget *slideshow_button;
GtkWidget *saveimage_button;

static GdkColor*  get_viewer_tooltips_bgcolor   ();

GtkWidget *
viewer_add_button_toolbar(GtkWidget *parent, GtkStyle *style,
                        GtkWidget *toolbar,
                        gchar **pix,
                        const char *tooltip_text,
                        GtkSignalFunc myfunction, gint value)
{
   GtkWidget *button;
   GtkWidget *pixmap_wid;
   GdkPixmap *pixmap;
   GdkBitmap *mask;

   pixmap = gdk_pixmap_create_from_xpm_d(parent->window, &mask,
                                          &style->bg[GTK_STATE_NORMAL],
                                          (gchar **)pix);

   pixmap_wid = gtk_pixmap_new(pixmap, mask);
   gtk_widget_show(pixmap_wid);
   button = gtk_toolbar_append_item(GTK_TOOLBAR(toolbar), NULL,
                                    tooltip_text, NULL,
                                    pixmap_wid,
                                    GTK_SIGNAL_FUNC(myfunction),
                                    (gint *) value);
   return button;
}

GtkWidget *
viewer_add_toggle_toolbar(GtkWidget *parent, GtkStyle *style,
                        GtkWidget *toolbar,
                        gchar **pix,
                        const char *tooltip_text,
                        GtkSignalFunc myfunction)
{
   GtkWidget *button;
   GtkWidget *pixmap_wid;
   GdkPixmap *pixmap;
   GdkBitmap *mask;

   pixmap = gdk_pixmap_create_from_xpm_d(parent->window, &mask,
                                          &style->bg[GTK_STATE_NORMAL],
                                          (gchar **)pix);

   pixmap_wid = gtk_pixmap_new(pixmap, mask);
   gtk_widget_show(pixmap_wid);

   button = gtk_toolbar_append_element(
      GTK_TOOLBAR(toolbar),
      GTK_TOOLBAR_CHILD_TOGGLEBUTTON,
      NULL,
      NULL,
      tooltip_text, NULL,
      pixmap_wid,
      GTK_SIGNAL_FUNC(myfunction),
      NULL);

   return button;
}

static GdkColor*
get_viewer_tooltips_bgcolor(GdkWindow *window, GdkColormap *colormap)
{
   static GdkColor color;
   static gboolean alloced = FALSE;
   if (!alloced)
   {
      color.red   = 61669;
      color.green = 59113;
      color.blue  = 35979;
      color.pixel = 0;
      gdk_color_alloc(colormap, &color);
      alloced = TRUE;
   }
   return &color;
}

void
viewer_save_enable(gboolean e)
{
   gtk_widget_set_sensitive(saveimage_button, e);
}

void
viewer_next_enable(gboolean e)
{
   gtk_widget_set_sensitive(next_button, e);
}

void
viewer_next_pressed()
{
   gtk_button_clicked(GTK_BUTTON(next_button));
}

void
viewer_prev_enable(gboolean e)
{
   gtk_widget_set_sensitive(prev_button, e);
}

void
viewer_prev_pressed()
{
   gtk_button_clicked(GTK_BUTTON(prev_button));
}

void
viewer_slideshow_set_state(gboolean e)
{
   gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(slideshow_button), e);
}

void
viewer_slideshow_pressed()
{
   gtk_button_clicked(GTK_BUTTON(slideshow_button));
}

void
viewer_slideshow_stop_by_next_prev()
{
   if (rc_get_boolean("full_screen")) return;

   if (GTK_TOGGLE_BUTTON(slideshow_button)->active)
   {
      gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(slideshow_button), FALSE);
   }
}

GtkWidget*
get_viewer_toolbar(GtkWidget *parent)
{
   GtkWidget *toolbar, *button;
   GtkStyle  *style;
   gboolean  fit_screen;

   style = gtk_widget_get_style(parent);
   toolbar = gtk_toolbar_new(GTK_ORIENTATION_HORIZONTAL, GTK_TOOLBAR_ICONS);
   gtk_tooltips_set_colors(
      GTK_TOOLBAR(toolbar)->tooltips,
      get_viewer_tooltips_bgcolor(parent->window, gdk_window_get_colormap(parent->window)),
      &style->fg[GTK_STATE_NORMAL]);
   gtk_tooltips_set_delay(GTK_TOOLBAR(toolbar)->tooltips, 100);

   viewer_add_button_toolbar(parent, style, toolbar,
                              (gchar **)browse_xpm,
                              _("Browse"),
                              GTK_SIGNAL_FUNC(viewer_toolbar_browse),
                              0);

   viewer_add_button_toolbar(parent, style, toolbar,
                              (gchar **)fullscreen_xpm,
                              _("Full screen"),
                              GTK_SIGNAL_FUNC(viewer_toolbar_full_screen),
                              0);

   gtk_toolbar_append_space(GTK_TOOLBAR(toolbar));

   saveimage_button = viewer_add_button_toolbar(parent, style, toolbar,
                              (gchar **)save_image_xpm,
                              _("Save Image"),
                              GTK_SIGNAL_FUNC(viewer_toolbar_save_image),
                              0);

   gtk_toolbar_append_space(GTK_TOOLBAR(toolbar));

   prev_button = viewer_add_button_toolbar(parent, style, toolbar,
                              (gchar **)prev_image_xpm,
                              _("Previous Image"),
                              GTK_SIGNAL_FUNC(viewer_toolbar_prev_image),
                              0);

   next_button = viewer_add_button_toolbar(parent, style, toolbar,
                              (gchar **)next_image_xpm,
                              _("Next Image"),
                              GTK_SIGNAL_FUNC(viewer_toolbar_next_image),
                              0);

   slideshow_button = viewer_add_toggle_toolbar(parent, style, toolbar,
                              (gchar **)slideshow_xpm,
                              _("Stop/Resume Slideshow"),
                              GTK_SIGNAL_FUNC(viewer_toolbar_slideshow_toggled));

   gtk_toolbar_append_space(GTK_TOOLBAR(toolbar));

   viewer_add_button_toolbar(parent, style, toolbar,
                              (gchar **)refresh_xpm,
                              _("Refresh"),
                              GTK_SIGNAL_FUNC(viewer_toolbar_refresh),
                              0);

   button = viewer_add_toggle_toolbar(parent, style, toolbar,
                              (gchar **)screen_xpm,
                              _("Fit Screen"),
                              GTK_SIGNAL_FUNC(viewer_toolbar_fitscreen_toggled));


   fit_screen = rc_get_boolean("fit_screen");
   gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(button), fit_screen);

   gtk_toolbar_append_space(GTK_TOOLBAR(toolbar));

   viewer_add_button_toolbar(parent, style, toolbar,
                              (gchar **)rotate_right_xpm,
                              _("Rotate +90"),
                              GTK_SIGNAL_FUNC(viewer_toolbar_rotate),
                              LEFT);

   viewer_add_button_toolbar(parent, style, toolbar,
                              (gchar **)rotate_left_xpm,
                              _("Rotate -90"),
                              GTK_SIGNAL_FUNC(viewer_toolbar_rotate),
                              RIGHT);

   gtk_toolbar_append_space(GTK_TOOLBAR(toolbar));

   viewer_add_button_toolbar(parent, style, toolbar,
                              (gchar **)right_left_xpm,
                              _("Reflect Right/Left"),
                              GTK_SIGNAL_FUNC(viewer_toolbar_reflect),
                              RIGHTLEFT);

   viewer_add_button_toolbar(parent, style, toolbar,
                              (gchar **)up_down_xpm,
                              _("Reflect Up/Down"),
                              GTK_SIGNAL_FUNC(viewer_toolbar_reflect),
                              UPDOWN);

   gtk_toolbar_append_space(GTK_TOOLBAR(toolbar));

   viewer_add_button_toolbar(parent, style, toolbar,
                              (gchar **)exit_xpm,
                              _("Exit"),
                              GTK_SIGNAL_FUNC(close_gtksee),
                              0);

   return toolbar;
}
