# -*- coding: utf-8 -*-

import gobject
import gtk
import os

class ImportList:
	def __init__(self, mainwin):
		self.mainwin = mainwin

	def import_listfile(self, filename):
		self.mainwin.enable_network = False
		self.mainwin.char_liststore = gtk.ListStore(gobject.TYPE_STRING, object, gobject.TYPE_BOOLEAN)
		lines = file(filename).readlines()
		for line in lines:
			utf8str = ""
			for ch in line:
				if (ch == '\0' or ch == '\n'):
					break
				utf8str += ch;
			if utf8str != "":
				self.mainwin.char_liststore.append([utf8str, [], False])

	def do_import(self):
		dialog = gtk.FileChooserDialog ("Select list file", 
				self.mainwin, 
				gtk.FILE_CHOOSER_ACTION_OPEN,
				(gtk.STOCK_OPEN, gtk.RESPONSE_OK,
				 gtk.STOCK_CANCEL, gtk.RESPONSE_CLOSE))
		listfilter = gtk.FileFilter()
		listfilter.set_name("UTF-8 list file")
		listfilter.add_pattern("*.list*")
		allfilter = gtk.FileFilter()
		allfilter.set_name("Any file")
		allfilter.add_pattern("*")
		dialog.add_filter(listfilter)
		dialog.add_filter(allfilter)
		dialog.set_default_response (gtk.RESPONSE_OK)
		dialog.set_position (gtk.WIN_POS_CENTER_ON_PARENT)
		dialog.set_current_folder(os.getenv("PWD") + "/data");
		retval = dialog.run ()
		if retval == gtk.RESPONSE_OK:
			self.import_listfile(dialog.get_filename())
		dialog.destroy ()
		
