#ifndef __LINQ_MAINWIN_CONTACTVIEW_H__
#define __LINQ_MAINWIN_CONTACTVIEW_H__

#include <string>
#include <gtk/gtk.h>
#include "udpsession.h"

enum ContactListNodeType {
	CONTACT_LIST_NODE_BUDDY,
	CONTACT_LIST_NODE_GROUP,
};

struct ContactListNode {
	ContactListNodeType type;
	std::string name;
	uint32 status;
};

class ContactView {
public:
	ContactView();
	~ContactView();
	GtkWidget *Create();
	void Destroy();
	void onUserOnline(const gchar *name);
	void onUserOffline(const gchar *name);
	void onUserStatus(const char *name, uint32 status);
	void onContactInfoReply(CONTACT_INFO &c);
private:
	void loadContactList();	

	gboolean get_iter_from_name(const gchar *name, GtkTreeIter *iter);
	gboolean get_iter_from_name_helper(const gchar *name, GtkTreeIter *iter, GtkTreeIter *root);
	static gboolean clear_tree_model_data(GtkTreeModel *model, GtkTreePath *path, GtkTreeIter *iter, gpointer data);

	GtkWidget *buddy_treeview;
	GtkTreeStore *buddy_tree_model;
	GtkWidget *buddy_scrollwindow;
	GtkWidget *group_treeview;
	GtkTreeStore *group_tree_model;
	GtkWidget *group_scrollwindow;
	
	GtkWidget *buddy_left_menu;
	GtkWidget *buddy_right_menu;
	GtkWidget *buddy_group_menu;

	static void on_buddy_button_clicked(GtkWidget *button, ContactView *oContactView);
	static void on_group_button_clicked(GtkWidget *button, ContactView *oContactView);
	static gboolean on_buddy_treeview_button_press(GtkWidget *widget, GdkEventButton *event, ContactView *oContactView);
	static gboolean on_group_treeview_button_press(GtkWidget *widget, GdkEventButton *event, ContactView *oContactView);
	static void on_buddy_treeview_realize(GtkWidget *widget, ContactView *oContactView);
	static void on_group_treeview_realize(GtkWidget *widget, ContactView *oContactView);

	static void on_buddy_left_menu_sendmsg_activate(GtkMenuItem *menuitem, ContactView *oContactView);
	static void on_buddy_left_menu_sendfile_activate(GtkMenuItem *menuitem, ContactView *oContactView);
	static void on_buddy_left_menu_sendmail_activate(GtkMenuItem *menuitem, ContactView *oContactView);
	static void on_buddy_left_menu_chatlog_activate(GtkMenuItem *menuitem, ContactView *oContactView);
	static void on_buddy_left_menu_viewinfo_activate(GtkMenuItem *menuitem, ContactView *oContactView);
	
	static void on_buddy_right_menu_addGroup_activate(GtkMenuItem *menuitem, ContactView *oContactView);
	static void on_buddy_right_menu_onlyShowOnlineUser_activate(GtkMenuItem *menuitem, ContactView *oContactView);
	static void on_buddy_right_menu_delete_activate(GtkMenuItem *menuitem, ContactView *oContactView);
	static void on_buddy_right_menu_rename_activate(GtkMenuItem *menuitem, ContactView *oContactView);
};

#endif
