#include "config.h"
#include "SendFileDlg.h"
#include "LinqMain.h"
#include "intl.h"

CSendFileDlg::CSendFileDlg(TCPSessionBase *tcp) : FileSession(tcp)
{
	transfer_size = 0;
	
	if (tcpSession->isSend()) {
		GtkWidget *file_selector = gtk_file_selection_new(_("Choose the file which you want to send"));
	
		gint result = gtk_dialog_run (GTK_DIALOG (file_selector));
		switch (result) {
			case GTK_RESPONSE_OK:
				filePath = gtk_file_selection_get_filename (GTK_FILE_SELECTION(file_selector));				
				break;
				
		}	
		gtk_widget_destroy (file_selector);
		
		if (result == GTK_RESPONSE_OK)
			sendFileInfo(filePath.c_str());
		else
			tcpSession->destroy();
	}
}

const char *CSendFileDlg::getPathName(const char *name, uint32 size)
{
	gchar *title = g_strdup_printf(_("Receive file. size: %u K. Save as..."), size/1024);
	GtkWidget *file_selector = gtk_file_selection_new(title);
	g_free(title);
	gtk_file_selection_set_filename(GTK_FILE_SELECTION(file_selector),name);
	
	gint result = gtk_dialog_run (GTK_DIALOG (file_selector));
	switch (result) {
	case GTK_RESPONSE_OK:
		filePath = gtk_file_selection_get_filename (GTK_FILE_SELECTION(file_selector));
		break;
	}	
	gtk_widget_destroy (file_selector);
	if (result == GTK_RESPONSE_OK)
		return filePath.c_str();
	else
		return NULL;
}

void CSendFileDlg::onFileProgress(int n)
{
	transfer_size += n;
}

void CSendFileDlg::onFileComplete()
{
	gtk_timeout_remove(update_progress_timeout);
	gtk_widget_destroy(progress_window);
	
	int costtime = (int)(difftime(time(NULL), start_time));
	if (costtime==0) //can't be div.
		costtime = 1;
	int speed = (int)((transfer_size / costtime)/1024);
	gchar *filename = g_filename_to_utf8(filePath.c_str(),-1,NULL,NULL,NULL);
	GtkWidget *dialog;
	if (transfer_size == fileSize) {
		if (tcpSession->isSend()) {
			dialog = gtk_message_dialog_new(GTK_WINDOW(linqMain->main_win->window), GTK_DIALOG_DESTROY_WITH_PARENT, GTK_MESSAGE_INFO, GTK_BUTTONS_CLOSE, _("File send successful!\nsend %u bytes cost %d seconds, %d k/s\nfilename: %s"), transfer_size, costtime, speed,filename);			
			g_signal_connect_swapped (GTK_OBJECT (dialog), "response", G_CALLBACK (gtk_widget_destroy), GTK_OBJECT (dialog));
			gtk_widget_show (dialog);
		}
		else {
			dialog = gtk_message_dialog_new(GTK_WINDOW(linqMain->main_win->window), GTK_DIALOG_DESTROY_WITH_PARENT, GTK_MESSAGE_INFO, GTK_BUTTONS_CLOSE, _("File receive successful!\nreceive %u bytes cost %d seconds, %d k/s\nsave as %s"), transfer_size, costtime,speed,filename);
			g_signal_connect_swapped (GTK_OBJECT (dialog), "response", G_CALLBACK (gtk_widget_destroy), GTK_OBJECT (dialog));
			gtk_widget_show (dialog);
		}
	}
	else {
		if (tcpSession->isSend()) {
			dialog = gtk_message_dialog_new(GTK_WINDOW(linqMain->main_win->window), GTK_DIALOG_DESTROY_WITH_PARENT, GTK_MESSAGE_INFO, GTK_BUTTONS_CLOSE, _("Error occupy while sending file!\nsend %u bytes,but it should be %u bytes.\ncost %d seconds, %d k/s\nfilename: %s"), transfer_size, fileSize, costtime,speed,filename);
			g_signal_connect_swapped (GTK_OBJECT (dialog), "response", G_CALLBACK (gtk_widget_destroy), GTK_OBJECT (dialog));
			gtk_widget_show (dialog);
		}
		else {
			dialog = gtk_message_dialog_new(GTK_WINDOW(linqMain->main_win->window), GTK_DIALOG_DESTROY_WITH_PARENT, GTK_MESSAGE_INFO, GTK_BUTTONS_CLOSE, _("Error occupy when receiving file!\nreceive %u bytes,but it should be %u bytes.\ncost %d seconds, %d k/s\nsave as %s"), transfer_size, fileSize,costtime,speed,filename);
			g_signal_connect_swapped (GTK_OBJECT (dialog), "response", G_CALLBACK (gtk_widget_destroy), GTK_OBJECT (dialog));
			gtk_widget_show (dialog);
		}
	}
	g_free(filename);
}

gboolean CSendFileDlg::update_progress_cb(gpointer data)
{
	CSendFileDlg *oCSendFileDlg = (CSendFileDlg *)data;
	int nowtime = (int)(difftime(time(NULL), oCSendFileDlg->start_time));
	if (oCSendFileDlg->fileSize==0 || nowtime==0) // it can't be div.
		return true;;
	gtk_progress_bar_set_fraction(GTK_PROGRESS_BAR(oCSendFileDlg->progressbar),((gfloat)(oCSendFileDlg->transfer_size) / (gfloat)(oCSendFileDlg->fileSize)));
	
	gchar *text = g_strdup_printf(_("%8d k/s"),(gint) ((oCSendFileDlg->transfer_size / nowtime)/1024));
	gtk_label_set_text(GTK_LABEL(oCSendFileDlg->speed_label),text);
	g_free(text);
	return true;
}

void CSendFileDlg::on_progress_window_delete_event (GtkWidget * widget, GdkEvent  *event, CSendFileDlg *oCSendFileDlg)
{
	oCSendFileDlg->onClose();
}

void CSendFileDlg::on_progress_window_stop_clicked (GtkWidget * widget, CSendFileDlg *oCSendFileDlg)
{
	oCSendFileDlg->onClose();
}

void CSendFileDlg::onFileStart()
{	
	start_time = time(NULL);
	
	progress_window = gtk_window_new(GTK_WINDOW_TOPLEVEL);

	g_signal_connect (G_OBJECT (progress_window), "delete_event", G_CALLBACK(on_progress_window_delete_event), this);
	gtk_window_set_resizable (GTK_WINDOW (progress_window), FALSE);
	if (tcpSession->isSend())
		gtk_window_set_title (GTK_WINDOW (progress_window), _("Sending file"));
	else
		gtk_window_set_title (GTK_WINDOW (progress_window), _("Receiving file"));
	gtk_container_set_border_width (GTK_CONTAINER (progress_window), 8);

	GtkWidget *vbox = gtk_vbox_new(FALSE,0);
	gtk_container_add (GTK_CONTAINER (progress_window), vbox);
	
	gchar *filename = g_filename_to_utf8(filePath.c_str(),-1,NULL,NULL,NULL);
	
	gchar *text;
	if (tcpSession->isSend())
		text = g_strdup_printf(_("Sending file. %s size: %u bytes"),filename, fileSize);		
	else
		text = g_strdup_printf(_("Receiving file. %s size: %u bytes"),filename, fileSize);
	g_free(filename);
	GtkWidget *label = gtk_label_new(text);
	g_free(text);
	gtk_box_pack_start_defaults(GTK_BOX(vbox),label);
	
	progressbar = gtk_progress_bar_new();
	gtk_box_pack_start_defaults(GTK_BOX(vbox),progressbar);
	
	speed_label = gtk_label_new(_("Waiting..."));
	gtk_box_pack_start_defaults(GTK_BOX(vbox), speed_label);
	
	GtkWidget *button = gtk_button_new_with_label(_("stop"));
	gtk_box_pack_start_defaults(GTK_BOX(vbox),button);
	g_signal_connect (G_OBJECT (button), "clicked", G_CALLBACK(on_progress_window_stop_clicked), this);
	
	gtk_widget_show_all(progress_window);
	
	update_progress_timeout = gtk_timeout_add(500, update_progress_cb, this);
}
