#include "config.h"
#include "SendMsgDlg.h"
#include "LinqMain.h"
#include "gtkimhtml.h"
#include <gdk/gdkkeysyms.h>
#include "intl.h"


SendMsgDlgTab::SendMsgDlgTab(SendMsgDlg *oSendMsgDlg, const char *name)
{
	this->oSendMsgDlg = oSendMsgDlg;
	this->contact_name = name;
	
	tab_cont = NULL;
	
	oSendMsgDlg->tabList.push_back(this);
}

SendMsgDlgTab::~SendMsgDlgTab()
{
	if (tab_cont)
		gtk_widget_destroy(tab_cont);
	
	oSendMsgDlg->tabList.remove(this);
}

void SendMsgDlgTab::Create()
{	
	GtkWidget *paned;
	paned = setup_im_pane();
	tab_cont = gtk_vbox_new(FALSE, 5);
	gtk_container_set_border_width(GTK_CONTAINER(tab_cont), 5);
	gtk_container_add(GTK_CONTAINER(tab_cont), paned);

	GtkWidget *tabby;
	tabby = gtk_hbox_new(FALSE, 5);
	GtkWidget *close;
	close = gtk_button_new();
	gtk_widget_set_size_request(GTK_WIDGET(close), 16, 16);
	gtk_container_add(GTK_CONTAINER(close), gtk_image_new_from_stock(GTK_STOCK_CLOSE, GTK_ICON_SIZE_MENU));
	gtk_button_set_relief(GTK_BUTTON(close), GTK_RELIEF_NONE);
	//gtk_tooltips_set_tip(gtkconv->tooltips, gtkconv->close, _("Close conversation"), NULL);

	//g_signal_connect(G_OBJECT(gtkconv->close), "clicked", G_CALLBACK(close_conv_cb), conv);

	GtkWidget *tab_label;
	tab_label = gtk_label_new(contact_name.c_str());

	gtk_box_pack_start(GTK_BOX(tabby), tab_label, TRUE, TRUE, 0);
	gtk_box_pack_start(GTK_BOX(tabby), close, FALSE, FALSE, 0);
	gtk_widget_show_all(tabby);
	
	gtk_notebook_append_page(GTK_NOTEBOOK(oSendMsgDlg->notebook), tab_cont, tabby);
	gtk_notebook_set_menu_label_text(GTK_NOTEBOOK(oSendMsgDlg->notebook), tab_cont,contact_name.c_str());
	gtk_widget_show_all(tab_cont);
}

void SendMsgDlgTab::onRecvMessage(time_t when, const char *text)
{
	char mdate[64];
	strftime(mdate, sizeof(mdate), "%H:%M:%S", localtime(&when));
	char buf[1024];
	g_snprintf(buf, sizeof(buf), "<FONT SIZE=\"2\">(%s) </FONT><B>%s: %s</B><BR>",
					   mdate, contact_name.c_str(), text);
	
	gtk_imhtml_append_text(GTK_IMHTML(imhtml), buf, -1, (GtkIMHtmlOptions)0);
}

void SendMsgDlgTab::Active()
{
	gint num = gtk_notebook_get_n_pages(GTK_NOTEBOOK(oSendMsgDlg->notebook));
	for (int i=num-1;i>=0;i--) {
		if (gtk_notebook_get_nth_page(GTK_NOTEBOOK(oSendMsgDlg->notebook), i) == tab_cont) {
			gtk_notebook_set_current_page(GTK_NOTEBOOK(oSendMsgDlg->notebook), i);
			break;
		}
	}
	gtk_widget_grab_focus(entry);
}

GtkWidget *SendMsgDlgTab::build_conv_toolbar()
{
	GtkWidget *vbox;
	vbox = gtk_vbox_new(FALSE, 0);
	GtkWidget *sep;
	sep = gtk_hseparator_new();
	gtk_box_pack_start(GTK_BOX(vbox), sep, FALSE, FALSE, 0);

	GtkWidget *hbox;
	hbox = gtk_hbox_new(FALSE, 5);
	gtk_box_pack_start(GTK_BOX(vbox), hbox, FALSE, FALSE, 0);
	
	bold_button = gtk_toggle_button_new();
	gtk_button_set_relief(GTK_BUTTON(bold_button), GTK_RELIEF_NONE);
	GtkWidget *image;
	image = gtk_image_new_from_stock(GTK_STOCK_BOLD, GTK_ICON_SIZE_MENU);
	gtk_container_add(GTK_CONTAINER(bold_button), image);
	gtk_box_pack_start(GTK_BOX(hbox), bold_button, FALSE, FALSE, 0);
	g_signal_connect(G_OBJECT(bold_button), "toggled", G_CALLBACK(on_bold_button_toggled), this);

	italic_button = gtk_toggle_button_new();
	gtk_button_set_relief(GTK_BUTTON(italic_button), GTK_RELIEF_NONE);
	image = gtk_image_new_from_stock(GTK_STOCK_ITALIC, GTK_ICON_SIZE_MENU);
	gtk_container_add(GTK_CONTAINER(italic_button), image);
	gtk_box_pack_start(GTK_BOX(hbox), italic_button, FALSE, FALSE, 0);
	g_signal_connect(G_OBJECT(italic_button), "toggled", G_CALLBACK(on_italic_button_toggled), this);

	underline_button = gtk_toggle_button_new();
	gtk_button_set_relief(GTK_BUTTON(underline_button), GTK_RELIEF_NONE);
	image = gtk_image_new_from_stock(GTK_STOCK_UNDERLINE, GTK_ICON_SIZE_MENU);
	gtk_container_add(GTK_CONTAINER(underline_button), image);
	gtk_box_pack_start(GTK_BOX(hbox), underline_button, FALSE, FALSE, 0);
	g_signal_connect(G_OBJECT(underline_button), "toggled", G_CALLBACK(on_underline_button_toggled), this);

	sep = gtk_vseparator_new();
	gtk_box_pack_start(GTK_BOX(hbox), sep, FALSE, FALSE, 0);

	bigfont_button = gtk_toggle_button_new();
	gtk_button_set_relief(GTK_BUTTON(bigfont_button), GTK_RELIEF_NONE);
	image = gtk_image_new_from_stock(GTK_STOCK_SELECT_FONT, GTK_ICON_SIZE_MENU);
	gtk_container_add(GTK_CONTAINER(bigfont_button), image);
	gtk_box_pack_start(GTK_BOX(hbox), bigfont_button, FALSE, FALSE, 0);
	g_signal_connect(G_OBJECT(bigfont_button), "toggled", G_CALLBACK(on_bigfont_button_toggled), this);

	normalfont_button = gtk_toggle_button_new();
	gtk_button_set_relief(GTK_BUTTON(normalfont_button), GTK_RELIEF_NONE);
	image = gtk_image_new_from_stock(GTK_STOCK_SELECT_FONT, GTK_ICON_SIZE_MENU);
	gtk_container_add(GTK_CONTAINER(normalfont_button), image);
	gtk_box_pack_start(GTK_BOX(hbox), normalfont_button, FALSE, FALSE, 0);
	g_signal_connect(G_OBJECT(normalfont_button), "toggled", G_CALLBACK(on_normalfont_button_toggled), this);

	smallfont_button = gtk_toggle_button_new();
	gtk_button_set_relief(GTK_BUTTON(smallfont_button), GTK_RELIEF_NONE);
	image = gtk_image_new_from_stock(GTK_STOCK_SELECT_FONT, GTK_ICON_SIZE_MENU);
	gtk_container_add(GTK_CONTAINER(smallfont_button), image);
	gtk_box_pack_start(GTK_BOX(hbox), smallfont_button, FALSE, FALSE, 0);
	g_signal_connect(G_OBJECT(smallfont_button), "toggled", G_CALLBACK(on_smallfont_button_toggled), this);

	sep = gtk_vseparator_new();
	gtk_box_pack_start(GTK_BOX(hbox), sep, FALSE, FALSE, 0);

	selectfont_button = gtk_toggle_button_new();
	gtk_button_set_relief(GTK_BUTTON(selectfont_button), GTK_RELIEF_NONE);
	image = gtk_image_new_from_stock(GTK_STOCK_SELECT_FONT, GTK_ICON_SIZE_MENU);
	gtk_container_add(GTK_CONTAINER(selectfont_button), image);
	gtk_box_pack_start(GTK_BOX(hbox), selectfont_button, FALSE, FALSE, 0);
	g_signal_connect(G_OBJECT(selectfont_button), "toggled", G_CALLBACK(on_selectfont_button_toggled), this);

	fgcolor_button = gtk_toggle_button_new();
	gtk_button_set_relief(GTK_BUTTON(fgcolor_button), GTK_RELIEF_NONE);
	image = gtk_image_new_from_stock(GTK_STOCK_SELECT_FONT, GTK_ICON_SIZE_MENU);
	gtk_container_add(GTK_CONTAINER(fgcolor_button), image);
	gtk_box_pack_start(GTK_BOX(hbox), fgcolor_button, FALSE, FALSE, 0);
	g_signal_connect(G_OBJECT(fgcolor_button), "toggled", G_CALLBACK(on_fgcolor_button_toggled), this);

	bgcolor_button = gtk_toggle_button_new();
	gtk_button_set_relief(GTK_BUTTON(bgcolor_button), GTK_RELIEF_NONE);
	image = gtk_image_new_from_stock(GTK_STOCK_SELECT_FONT, GTK_ICON_SIZE_MENU);
	gtk_container_add(GTK_CONTAINER(bgcolor_button), image);
	gtk_box_pack_start(GTK_BOX(hbox), bgcolor_button, FALSE, FALSE, 0);
	g_signal_connect(G_OBJECT(bgcolor_button), "toggled", G_CALLBACK(on_bgcolor_button_toggled), this);

	sep = gtk_vseparator_new();
	gtk_box_pack_start(GTK_BOX(hbox), sep, FALSE, FALSE, 0);

	smilies_button = gtk_toggle_button_new();
	gtk_button_set_relief(GTK_BUTTON(smilies_button), GTK_RELIEF_NONE);
	image = gtk_image_new_from_stock(GTK_STOCK_SELECT_FONT, GTK_ICON_SIZE_MENU);
	gtk_container_add(GTK_CONTAINER(smilies_button), image);
	gtk_box_pack_start(GTK_BOX(hbox), smilies_button, FALSE, FALSE, 0);
	g_signal_connect(G_OBJECT(smilies_button), "toggled", G_CALLBACK(on_smilies_button_toggled), this);

	sep = gtk_hseparator_new();
	gtk_box_pack_start(GTK_BOX(vbox), sep, FALSE, FALSE, 0);
	
	return vbox;
}

void SendMsgDlgTab::setup_im_buttons(GtkWidget *bbox)
{
	send_button = gtk_button_new();
	gtk_button_set_relief(GTK_BUTTON(send_button), GTK_RELIEF_NONE);
	GtkWidget *image;
	image = gtk_image_new_from_stock(GTK_STOCK_CONVERT, GTK_ICON_SIZE_BUTTON);
	gtk_container_add(GTK_CONTAINER(send_button), image);
	gtk_box_pack_end(GTK_BOX(bbox), send_button, FALSE, FALSE, 0);
	g_signal_connect(G_OBJECT(send_button), "clicked", G_CALLBACK(on_send_button_clicked), this);
	
	GtkWidget *separator;
	separator = gtk_vseparator_new();
	gtk_box_pack_end(GTK_BOX(bbox), separator, FALSE, TRUE, 0);

	warning_button = gtk_button_new();
	gtk_button_set_relief(GTK_BUTTON(warning_button), GTK_RELIEF_NONE);
	image = gtk_image_new_from_stock(GTK_STOCK_DIALOG_WARNING, GTK_ICON_SIZE_BUTTON);
	gtk_container_add(GTK_CONTAINER(warning_button), image);
	gtk_box_pack_start(GTK_BOX(bbox), warning_button, FALSE, FALSE, 0);
	g_signal_connect(G_OBJECT(warning_button), "clicked", G_CALLBACK(on_warning_button_clicked), this);

	info_button = gtk_button_new();
	gtk_button_set_relief(GTK_BUTTON(info_button), GTK_RELIEF_NONE);
	image = gtk_image_new_from_stock(GTK_STOCK_FIND, GTK_ICON_SIZE_BUTTON);
	gtk_container_add(GTK_CONTAINER(info_button), image);
	gtk_box_pack_start(GTK_BOX(bbox), info_button, FALSE, FALSE, 0);	
	g_signal_connect(G_OBJECT(info_button), "clicked", G_CALLBACK(on_info_button_clicked), this);
}

GtkWidget *SendMsgDlgTab::setup_im_pane()
{
	GtkWidget *paned;
	paned = gtk_vpaned_new();
	GtkWidget *vbox;
	vbox = gtk_vbox_new(FALSE, 5);
	gtk_paned_pack1(GTK_PANED(paned), vbox, TRUE, TRUE);
	
	GtkWidget *sw;
	sw = gtk_scrolled_window_new(NULL, NULL);
	gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW(sw), GTK_POLICY_NEVER, GTK_POLICY_ALWAYS);
	gtk_scrolled_window_set_shadow_type(GTK_SCROLLED_WINDOW(sw), GTK_SHADOW_IN);
	gtk_box_pack_start(GTK_BOX(vbox), sw, TRUE, TRUE, 0);
	gtk_widget_set_size_request(sw, 230, 150);	
	imhtml = gtk_imhtml_new(NULL, NULL);
	gtk_container_add(GTK_CONTAINER(sw), imhtml);
	gtk_imhtml_show_comments(GTK_IMHTML(imhtml), true);
	
	GtkWidget *vbox2;
	vbox2 = gtk_vbox_new(FALSE, 5);
	gtk_paned_pack2(GTK_PANED(paned), vbox2, FALSE, FALSE);
	GtkWidget *toolbar;
	toolbar = build_conv_toolbar();
	gtk_box_pack_start(GTK_BOX(vbox2), toolbar, FALSE, FALSE, 0);
	GtkWidget *frame;
	frame = gtk_frame_new(NULL);
	gtk_frame_set_shadow_type(GTK_FRAME(frame), GTK_SHADOW_IN);
	gtk_box_pack_start(GTK_BOX(vbox2), frame, TRUE, TRUE, 0);
	entry = gtk_text_view_new();	
	gtk_text_view_set_wrap_mode(GTK_TEXT_VIEW(entry), GTK_WRAP_WORD);
	gtk_widget_set_size_request(entry, -1, 45);
	gtk_container_add(GTK_CONTAINER(frame), GTK_WIDGET(entry));
	gtk_widget_grab_focus(entry);
	g_signal_connect(G_OBJECT(entry), "key_press_event", G_CALLBACK(on_entry_key_press_event), this);

	GtkWidget *bbox;
	bbox = gtk_hbox_new(FALSE, 5);
	gtk_box_pack_start(GTK_BOX(vbox2), bbox, FALSE, FALSE, 0);
	setup_im_buttons(bbox);
	
	return paned;
}

void SendMsgDlgTab::on_bold_button_toggled(GtkToggleButton *togglebutton, SendMsgDlgTab *oSendMsgDlgTab)
{
}

void SendMsgDlgTab::on_italic_button_toggled(GtkToggleButton *togglebutton, SendMsgDlgTab *oSendMsgDlgTab)
{
}

void SendMsgDlgTab::on_underline_button_toggled(GtkToggleButton *togglebutton, SendMsgDlgTab *oSendMsgDlgTab)
{
}

void SendMsgDlgTab::on_bigfont_button_toggled(GtkToggleButton *togglebutton, SendMsgDlgTab *oSendMsgDlgTab)
{
}

void SendMsgDlgTab::on_normalfont_button_toggled(GtkToggleButton *togglebutton, SendMsgDlgTab *oSendMsgDlgTab)
{
}

void SendMsgDlgTab::on_smallfont_button_toggled(GtkToggleButton *togglebutton, SendMsgDlgTab *oSendMsgDlgTab)
{
}

void SendMsgDlgTab::on_selectfont_button_toggled(GtkToggleButton *togglebutton, SendMsgDlgTab *oSendMsgDlgTab)
{
}

void SendMsgDlgTab::on_fgcolor_button_toggled(GtkToggleButton *togglebutton, SendMsgDlgTab *oSendMsgDlgTab)
{
}

void SendMsgDlgTab::on_bgcolor_button_toggled(GtkToggleButton *togglebutton, SendMsgDlgTab *oSendMsgDlgTab)
{
}

void SendMsgDlgTab::on_smilies_button_toggled(GtkToggleButton *togglebutton, SendMsgDlgTab *oSendMsgDlgTab)
{
}

void SendMsgDlgTab::on_send_button_clicked(GtkWidget *widget, SendMsgDlgTab *oSendMsgDlgTab)
{
	GtkTextIter start, end;
	GtkTextBuffer *buffer = gtk_text_view_get_buffer(GTK_TEXT_VIEW(oSendMsgDlgTab->entry));
	gtk_text_buffer_get_bounds(buffer, &start, &end);
	gchar *text = gtk_text_buffer_get_text(buffer, &start, &end, FALSE);
	if (text && text[0]) {
		linqMain->getUDPSession()->sendMessage(MSG_TEXT, oSendMsgDlgTab->contact_name.c_str(), text);
		gtk_text_buffer_delete(buffer, &start, &end);

		time_t when;
		when = time(NULL);
		char mdate[64];
		strftime(mdate, sizeof(mdate), "%H:%M:%S", localtime(&when));
		char buf[1024];
		g_snprintf(buf, sizeof(buf), "<FONT SIZE=\"2\">(%s) </FONT><B>%s: %s</B><BR>",
					   mdate, linqMain->myInfo.name.c_str(), text);
	
		gtk_imhtml_append_text(GTK_IMHTML(oSendMsgDlgTab->imhtml), buf, -1, (GtkIMHtmlOptions)0);
		
		g_free(text);
	}	
}

void SendMsgDlgTab::on_warning_button_clicked(GtkWidget *widget, SendMsgDlgTab *oSendMsgDlgTab)
{
}

void SendMsgDlgTab::on_info_button_clicked(GtkWidget *widget, SendMsgDlgTab *oSendMsgDlgTab)
{
}

gboolean SendMsgDlgTab::on_entry_key_press_event(GtkWidget *entry, GdkEventKey *event, SendMsgDlgTab *oSendMsgDlgTab)
{
	gboolean return_val=true;  //if return TRUE,the widget which in the main window will not receive any keyboard event.
	
	gboolean only_ctrl_pressed = ((event->state & GDK_CONTROL_MASK)&&(!(event->state & GDK_MOD1_MASK))&&(!(event->state & GDK_SHIFT_MASK)));
	//gboolean only_mod1_pressed = ((event->state & GDK_MOD1_MASK)&&(!(event->state & GDK_CONTROL_MASK))&&(!(event->state & GDK_SHIFT_MASK)));

	switch (event->keyval) {
		case GDK_Return:
			if (event->type==GDK_KEY_PRESS && only_ctrl_pressed) {
				oSendMsgDlgTab->on_send_button_clicked(entry, oSendMsgDlgTab);
			}
			else
				return_val = false;
			break;
		default:
			return_val = false;
			break;
	}

	return return_val;
}


SendMsgDlg::SendMsgDlg() : LinqWindow(WIN_SEND_MESSAGE)
{
	window = NULL;
}

SendMsgDlg::~SendMsgDlg()
{
	while (!tabList.empty())
		delete (SendMsgDlgTab *) tabList.front(); //it will remove from tabList when be deleted.

	if (window)
		gtk_widget_destroy(window);
}

void SendMsgDlg::Show(const char *name, time_t when, const char *text)
{
	gboolean have_window;
	if (!window) {
		create_window();
		have_window = false;
	}
	else {
		have_window = true;
	}
	
	gboolean found = false;
	std::list<SendMsgDlgTab *>::iterator iter;
	for (iter = tabList.begin(); iter!= tabList.end(); ++iter) {
		if ((*iter)->contact_name == name) {			
			if (text)
				(*iter)->onRecvMessage(when, text);
			else
				(*iter)->Active(); //user clicked the send msg menu.
			found = true;
			break;
		}
	}
	if (!found) {
		SendMsgDlgTab *tab;
		tab = new SendMsgDlgTab(this, name);
		tab->Create();
		if (text)
				tab->onRecvMessage(when, text);
		tab->Active();
	}
	
	if (have_window)
		gtk_window_present(GTK_WINDOW(window));
	else
		gtk_widget_show_all(window);
}

void SendMsgDlg::create_window()
{
	window = gtk_window_new(GTK_WINDOW_TOPLEVEL);

	g_signal_connect (G_OBJECT (window), "delete_event", G_CALLBACK(on_window_deleteevent), this);
	gtk_window_set_title (GTK_WINDOW (window), _("LinQ - Send message"));
	
	notebook = gtk_notebook_new();
	gtk_notebook_set_scrollable(GTK_NOTEBOOK(notebook), true);
	gtk_notebook_popup_enable(GTK_NOTEBOOK(notebook));
	
	GtkWidget *vbox;
	vbox = gtk_vbox_new(FALSE, 0);

	GtkWidget *menubar;
	menubar = setup_menubar();
	gtk_box_pack_start(GTK_BOX(vbox), menubar, FALSE, TRUE, 0);

	gtk_box_pack_start(GTK_BOX(vbox), notebook, TRUE, TRUE, 0);

	gtk_container_add(GTK_CONTAINER(window), vbox);	
}

GtkWidget *SendMsgDlg::setup_menubar()
{
	GtkWidget *menu_bar;
	menu_bar = gtk_menu_bar_new ();

	GtkWidget *root_menu;
	root_menu = gtk_menu_item_new_with_mnemonic (_("_Conservation"));

	GtkWidget *menu;	
	menu = gtk_menu_new ();
	GtkWidget *menu_items;
	menu_items = gtk_menu_item_new_with_mnemonic (_("View _histroy"));
	gtk_menu_shell_append (GTK_MENU_SHELL (menu), menu_items);
	menu_items = gtk_menu_item_new_with_mnemonic (_("_Close"));
	gtk_menu_shell_append (GTK_MENU_SHELL (menu), menu_items);	
	
	gtk_menu_item_set_submenu (GTK_MENU_ITEM (root_menu), menu);
	
	gtk_menu_shell_append (GTK_MENU_SHELL (menu_bar), root_menu);
	

	root_menu = gtk_menu_item_new_with_mnemonic (_("_Option"));

	menu = gtk_menu_new ();
	menu_items = gtk_menu_item_new_with_mnemonic (_("Enabel _sound"));
	gtk_menu_shell_append (GTK_MENU_SHELL (menu), menu_items);	
	
	gtk_menu_item_set_submenu (GTK_MENU_ITEM (root_menu), menu);
	
	gtk_menu_shell_append (GTK_MENU_SHELL (menu_bar), root_menu);
	
	return menu_bar;
}

gboolean SendMsgDlg::on_window_deleteevent(GtkWidget * widget, GdkEvent * event, SendMsgDlg *oSendMsgDlg)
{
	delete oSendMsgDlg;
	return true;
}
