#include "config.h"
#include "SysMsgDlg.h"
#include "LinqMain.h"
#include "intl.h"

SysMsgDlg::SysMsgDlg() : LinqWindow(WIN_SYS_MESSAGE)
{
	window = NULL;
}

SysMsgDlg::~SysMsgDlg()
{
	if (window)
		gtk_widget_destroy(window);
}

void SysMsgDlg::Create()
{
	window = gtk_window_new(GTK_WINDOW_TOPLEVEL);

	g_signal_connect (G_OBJECT (window), "delete_event", G_CALLBACK(on_window_deleteevent), this);
	gtk_window_set_title (GTK_WINDOW (window), _("LinQ - Sys message"));
	
	GtkWidget *vbox;
	vbox = gtk_vbox_new(false, 0);
	gtk_container_add(GTK_CONTAINER(window), vbox);
	
	GtkWidget *frame;
	frame = gtk_frame_new("Come from");
	gtk_box_pack_start(GTK_BOX(vbox), frame,false,false,0);
	
	GtkWidget *hbox;
	hbox = gtk_hbox_new(false, 0);
	gtk_container_add(GTK_CONTAINER(frame), hbox);
	GtkWidget *label;
	label = gtk_label_new("LinQ#: ");
	gtk_box_pack_start(GTK_BOX(hbox), label,false,false,0);
	from_entry = gtk_entry_new();
	gtk_box_pack_start(GTK_BOX(hbox), from_entry,false,false,0);
	label = gtk_label_new("Nick name:");
	gtk_box_pack_start(GTK_BOX(hbox), label,false,false,0);
	GtkWidget *entry;
	entry = gtk_entry_new();
	gtk_box_pack_start(GTK_BOX(hbox), entry,false,false,0);
	label = gtk_label_new("Detail info->");
	gtk_box_pack_start(GTK_BOX(hbox), label,false,false,0);
	GtkWidget *button;
	button = gtk_button_new();
	gtk_box_pack_start(GTK_BOX(hbox), button,false,false,0);
	g_signal_connect (G_OBJECT (button), "clicked", G_CALLBACK(on_detailInfo_button_clicked), this);
	GtkWidget *image;
	image = gtk_image_new_from_pixbuf(linqMain->skin->linq.face[0]);
	gtk_container_add(GTK_CONTAINER(button), image);
	
	label = gtk_label_new("Message content");
	gtk_box_pack_start(GTK_BOX(vbox), label,false,false,0);
	
	frame = gtk_frame_new(NULL);
	gtk_box_pack_start(GTK_BOX(vbox), frame, false, false, 0);
	gtk_frame_set_shadow_type(GTK_FRAME(frame), GTK_SHADOW_IN);	
	textview = gtk_text_view_new();
	gtk_text_view_set_wrap_mode(GTK_TEXT_VIEW(textview), GTK_WRAP_WORD);
	gtk_widget_set_size_request(textview, -1, 100);
	gtk_container_add(GTK_CONTAINER(frame), GTK_WIDGET(textview));
	
	button_hbox = gtk_hbox_new(false, 0);
	gtk_box_pack_start(GTK_BOX(vbox), button_hbox, false, false, 0);
	button = gtk_button_new_with_label(_("Close"));
	gtk_box_pack_end(GTK_BOX(button_hbox), button,false,false,0);
	g_signal_connect (G_OBJECT (button), "clicked", G_CALLBACK(on_close_button_clicked), this);
	gtk_widget_show_all(window);
}

void SysMsgDlg::onRecvMessage(uint8 type, const char *from, time_t when, const char *text)
{
	gtk_entry_set_text(GTK_ENTRY(from_entry), from);
	GtkWidget *button;
	gchar *msg = NULL;
	if (type == MSG_AUTH_ACCEPTED) {
		msg = g_strdup_printf("User %s have accepted your authorization request.\n\nAppend msg:%s", from, text ? text: _("NULL"));
	}
	else if (type == MSG_AUTH_REJECTED) {
		msg = g_strdup_printf("User %s have rejected your authorization request.\n\nAppend msg:%s", from, text ? text: _("NULL"));
	}
	else if (type == MSG_AUTH_REQUEST) {
		msg = g_strdup_printf("User %s request for your authorization.\n\nAppend msg:%s", from, text ? text: _("NULL"));
		button = gtk_button_new_with_label(_("accept"));
		gtk_box_pack_start(GTK_BOX(button_hbox), button,false,false,0);
		g_signal_connect (G_OBJECT (button), "clicked", G_CALLBACK(on_accept_button_clicked), this);
		button = gtk_button_new_with_label(_("reject"));
		gtk_box_pack_start(GTK_BOX(button_hbox), button,false,false,0);
		g_signal_connect (G_OBJECT (button), "clicked", G_CALLBACK(on_reject_button_clicked), this);
		button = gtk_button_new_with_label(_("add friend"));
		gtk_box_pack_end(GTK_BOX(button_hbox), button,false,false,0);
		g_signal_connect (G_OBJECT (button), "clicked", G_CALLBACK(on_addFriend_button_clicked), this);
	}
	else if (type == MSG_ADDED) {
		msg = g_strdup_printf("User %s have add you to his/her contact list.", from);
		button = gtk_button_new_with_label(_("add friend"));
		gtk_box_pack_end(GTK_BOX(button_hbox), button,false,false,0);
	}
	gtk_text_buffer_set_text(gtk_text_view_get_buffer(GTK_TEXT_VIEW(textview)), msg, -1);
	g_free(msg);	
}

void SysMsgDlg::onAddContactReply(const char *name, uint8 auth)
{
	gchar *msg = NULL;
	switch (auth) {
	case AUTH_ACCEPTED:
		msg = g_strdup_printf("%s accepted your request", name);
		break;
	case AUTH_REJECTED:
		msg = g_strdup_printf("%s rejected your request", name);
		break;
	case AUTH_REQUEST:
		msg = g_strdup_printf("%s require your request", name);
		break;
	}
	gtk_text_buffer_set_text(gtk_text_view_get_buffer(GTK_TEXT_VIEW(textview)), msg, -1);
	g_free(msg);
}

gboolean SysMsgDlg::on_window_deleteevent(GtkWidget * widget, GdkEvent * event, SysMsgDlg *oSysMsgDlg)
{
	delete oSysMsgDlg;
	return true;
}

void SysMsgDlg::on_detailInfo_button_clicked(GtkWidget * widget, SysMsgDlg *oSysMsgDlg)
{
}

void SysMsgDlg::on_accept_button_clicked(GtkWidget * widget, SysMsgDlg *oSysMsgDlg)
{
}

void SysMsgDlg::on_reject_button_clicked(GtkWidget * widget, SysMsgDlg *oSysMsgDlg)
{
}

void SysMsgDlg::on_addFriend_button_clicked(GtkWidget * widget, SysMsgDlg *oSysMsgDlg)
{
}

void SysMsgDlg::on_close_button_clicked(GtkWidget * widget, SysMsgDlg *oSysMsgDlg)
{
	delete oSysMsgDlg;
}
