#include "passwd.h"
#include "mapi.h"
#include "session.h"
#include "dbconn.h"
#include "packet.h"
#include "sha.h"
#include "sqlstmt.h"
#include "proto.h"
#include "debug.h"
#include <stdlib.h>

static void onPreChangePassword(EVENT *ev)
{
	SQLStmt sql(ev->conn);

	SQL_APPEND(sql, "SELECT token, sequence FROM user_tbl WHERE id=");
	sql << ev->s->getUserID();

	DBResult *res;
	
	if (!ev->conn->query(sql.getData(), sql.getLength()) ||
		!(res = ev->conn->getResult()))
		return;

	DB_ROW row = res->fetchRow();
	if (row) {
		uint16 sequence = atoi(row[1]);

		OutPacket out;
		out << sequence << row[0];

		ev->s->deliver(CMD_PRE_CHANGE_PASSWD, out.data, out.getLength());
	}

	res->destroy();
}

static void onChangePassword(EVENT *ev)
{	
	InPacket in(ev->packet->data, ev->packet->dataLen);

	ICQ_STR hash;
	
	in >> hash;
		
	SQLStmt sql(ev->conn);
	uint32 id = ev->s->getUserID();

	SQL_APPEND(sql, "SELECT hash FROM user_tbl WHERE id=");
	sql << id;
	
	DBResult *res;
	DB_ROW row;

	if (!ev->conn->query(sql.getData(), sql.getLength()) || !(res = ev->conn->getResult())) {		
	}
	else {
		if (!(row = res->fetchRow())) {
		}
		else {
			char hash2[41];
			shahash_r(hash.text, hash2);
			hash2[40] = '\0';
			if (strcmp(hash2, row[0]) != 0) {
			}
			else {
				ICQ_STR newHash, newToken;
				uint16 newSequence;
				in >> newHash >> newToken >> newSequence;
				if (newHash.len <= 0 || newHash.len > 40 || newToken.len <= 0 || newToken.len > 10 || newSequence <= 0) {						
				}
				else {
					sql.reset();
					SQL_APPEND(sql, "UPDATE user_tbl SET token =");
					sql << newToken.text;
					SQL_APPEND(sql, ",sequence=");
					sql <<  (uint32)newSequence;
					SQL_APPEND(sql, ",hash=");
					sql << newHash.text;
					SQL_APPEND(sql, " WHERE id=");
					sql << id;
					if (!ev->conn->query(sql.getData(), sql.getLength())) {							
					}
					else if (ev->conn->getAffectedRows()) {
						//success
					}
				}
			}
		}
		res->destroy();
	}
}

bool Passwd::handleEvent(EVENT *ev, void *data)
{
	ICQ_ASSERT(ev->event == EV_S_OUT);

	switch (ev->packet->cmd) {
	case CMD_PRE_CHANGE_PASSWD:
		onPreChangePassword(ev);
		break;

	case CMD_CHANGE_PASSWD:
		onChangePassword(ev);
		break;

	default:
		return false;
	}

	return true;
}

bool Passwd::init(int module, MAPI *mapi, Profile *prof)
{
	mapi->registerEvent(module, EV_S_OUT);
	return true;
}


ICQ_EXPORT ModuleListener *getModuleListener()
{
	return new Passwd;
}
