/*
    writer : Opera Wang
    E-Mail : wangvisual AT sohu.com
    License: GPL
*/

/* filename: getini.c */

#include "getini.h"

#define GETINI_MAX_PATH_LEN 256

#ifdef __cplusplus
extern "C" {
#endif

void GetIniFileName( const char * BaseFileName, char * FileName )
{
    char* pUserHome;
    struct passwd *pw;
    if ( BaseFileName==NULL || strlen(BaseFileName)==0 )
    {
        strcpy(FileName,"ERROR");
        return;
    }
    
    setpwent();
    pw = getpwuid(getuid());
    endpwent();

    if (pw)
        pUserHome=pw->pw_dir;
    if (!pUserHome)
        pUserHome=getenv("HOME");
    
	if(pUserHome!=NULL)
    {
		strcpy(FileName,pUserHome);             /* /home/r59182             */
		strcat(FileName,"/");                   /* /home/r59182/            */
        strcat(FileName,BaseFileName);          /* /home/r59182/.stardic    */
	}
    else
        strcpy(FileName,BaseFileName);
    return;
}

/* return true(1) if find Name in file, else return false(0) */
char GetStringFromIni( const char * FileName, const char * Name, char * String, const char * DefaultString)
{
    FILE * IniFile;
    char line[GETINI_MAX_PATH_LEN+1];
    if ( (IniFile=fopen(FileName,"r")) != NULL )
    {
        while ( fgets(line,GETINI_MAX_PATH_LEN,IniFile) !=  NULL )
        {
            if ( strstr(line,Name) == line )     /* find */
            {
                /* find "=" */
                char * EqualPos = line+strlen(Name);
                if ( *EqualPos == '=' )
                {
                    char * EndBlanks;
                    strcpy(String,EqualPos+1);
                    EndBlanks = String+strlen(String)-1;
                    while ( EndBlanks >= String && (*EndBlanks==' '||*EndBlanks=='\n') )
                        *EndBlanks-- = '\0';
                    fclose(IniFile);
                    return '\1'; /* true */
                }
                    
            }
        }
        fclose(IniFile);
    }
    if (DefaultString)
        strcpy(String,DefaultString);
    else
        String[0]='\0';
    return '\0'; /* false */
}

int GetIntFromIni( const char * FileName, const char * Name, int * Value, const int DefaultInt)
{
    char ValueString[GETINI_MAX_PATH_LEN+1],DefaultString[GETINI_MAX_PATH_LEN+1];
    sprintf(DefaultString,"%d",DefaultInt);
    GetStringFromIni(FileName,Name,ValueString,DefaultString);
    if ( Value == NULL )
        return atoi(ValueString);
    else
        return ( *Value = atoi(ValueString) );
}

void SaveStringToIni( const char * FileName, const char * Name, const char * String)
{
    FILE * IniFile;
    char line[GETINI_MAX_PATH_LEN+1];
    long CurrentLineStartPos=0;
    if ( access(FileName,F_OK) == -1 )  /* File Not Exist */
        IniFile = fopen(FileName,"w+");
    else
        IniFile = fopen(FileName,"r+");
    if ( IniFile != NULL )
    {
        while ( fgets(line,GETINI_MAX_PATH_LEN,IniFile) !=  NULL )
        {
            if ( strstr(line,Name) == line )     /* find */
            {
                /* find "=" */
                char * EqualPos = line+strlen(Name);
                if ( *EqualPos == '=' )
                {
                    int space,needspace;
                    char TargetLine[GETINI_MAX_PATH_LEN+1];
                    char * EndBlanks = line+strlen(line)-1;
                    char SavedLine[GETINI_MAX_PATH_LEN+1];                    
                    while ( EndBlanks >= EqualPos && (*EndBlanks==' '||*EndBlanks=='\n') )
                        *EndBlanks-- = '\0';
                    if ( strcmp(String,EqualPos+1) == 0 )   /* equal */
                    {    
                        fclose(IniFile);
                        return;
                    }
                    /* have to change */
                    space=ftell(IniFile)-CurrentLineStartPos;
                    sprintf(TargetLine,"%s=%s\n",Name,String);
                    if ( space >= (int)strlen(TargetLine) )  /* space is enough */
                    {
                        fseek(IniFile,CurrentLineStartPos,SEEK_SET);
                        fprintf(IniFile,"%s=%s",Name,String);
                        space -= strlen(TargetLine);
                        while ( space-- )
                            fputc(' ',IniFile);
                        fputc('\n',IniFile);
                        fclose(IniFile);
                        return;
                    }
                    /* not enough Space */
                    SavedLine[0]='\0';
                    needspace = strlen(TargetLine) - space;
                    while (needspace>0)
                    {
                        fgets(line,GETINI_MAX_PATH_LEN,IniFile);
                        strcat(SavedLine,line);
                        needspace -= strlen(line);
                    }
                    fseek(IniFile,CurrentLineStartPos,SEEK_SET);
                    fprintf(IniFile,"%s=%s",Name,String);
                    while (needspace)
                    {
                        fputc(' ',IniFile);
                        needspace++;
                    }
                    fputc('\n',IniFile);
                    fseek(IniFile,0,SEEK_END);
                    fprintf(IniFile,"%s",SavedLine);
                    fclose(IniFile);
                    return;
                }
                    
            }
            CurrentLineStartPos = ftell(IniFile);
        }       /*end of while */
        /* not find */
        fprintf(IniFile,"%s=%s     \n",Name,String);    /* Add 5 more blanks */
        fclose(IniFile);
    }
    return;
}

void SaveIntToIni( const char * FileName, const char * Name, const int Value)
{
    char ValueString[GETINI_MAX_PATH_LEN+1];
    sprintf(ValueString,"%d",Value);
    SaveStringToIni(FileName,Name,ValueString);
}

#ifdef	__cplusplus
}
#endif
