#ifndef OPERA_OCR_H
#define OPERA_OCR_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <X11/Xlib.h>

class OCR
{
private:
        Display * m_display;
        XRectangle  xrect;  // image size
        int rootx, rooty;   // mouse position
        int iWindowWidth;   // Get Image Window
        int iWindowHeight;
        unsigned char * ImageBuffer;
        Window wGetTopLevelWindow(Window win);
        bool bGetImageAtMouse(void);
        int highbit( unsigned long ul )
        {
            int i;
            for ( i = 31; ( ( ul & 0x80000000 ) == 0 ) && i >= 0; i--, ul <<= 1 );
            return i;
        };
public:
        OCR(void);
        ~OCR();
        bool bInit(Display * display);
        char * sSimpleGetWord(void);
        char * sGetPossibleWords(void);
//        char * sSimpleGetWordWithDict(void);
};

#endif  // OPERA_OCR_H
