/*
    writer : Opera Wang (Wang Wei)
    E-Mail : wangvisual AT sohu DOT com
    License: GPL
KDE3 docking protocols:
http://developer.kde.org/documentation/library/kdeqt/kde3arch/protocols-docking.html
System Tray Protocol Specification:
http://www.freedesktop.org/standards/systemtray/systemtray-spec.html
*/

/* bug: name property, balloon message */

#include "trayicon.h"
#include <assert.h>
#include <stdio.h>
#include <string.h>
#include <X11/extensions/shape.h>

#ifndef XmUNSPECIFIED_PIXMAP
#define XmUNSPECIFIED_PIXMAP 2
#endif

TrayIcon::TrayIcon()
{
#ifndef NDEBUG
    printf("Tray Icon module start... [ By Opera Wang <wangvisual AT sohu DOT com> ]\n");
#endif
    _NET_SYSTEM_TRAY_OPCODE_Atom=_NET_SYSTEM_TRAY_Sn_Atom=KWM_DOCKWINDOW_Atom=
        _KDE_NET_SYSTEM_TRAY_WINDOW_FOR_Atom=TRAYICON_MESSAGE_TYPE_Atom=None;
    m_window = m_traywindow = 0;
    m_display = NULL;
    m_traystyle = NotValid;
}

TrayIcon::~TrayIcon()
{
#ifndef NDEBUG
    printf("Tray Icon module end\n");
#endif
    vDestroyTrayWindow();
}

void TrayIcon::vDestroyTrayWindow()
{
    if(m_traywindow)
    {
        XSelectInput(m_display,m_traywindow,0L);
        XDestroyWindow(m_display,m_traywindow);
        m_traywindow = 0;
    }
}

void TrayIcon::vCreateTrayWindow()
{
    vDestroyTrayWindow();
    // create m_traywindow
    m_traywindow = XCreateSimpleWindow(m_display,DefaultRootWindow(m_display),0,0,24,24,0,0,0);
    XSizeHints sizehints;
    memset(&sizehints,0,sizeof(sizehints));
    sizehints.flags=USSize|PMinSize|PMaxSize;
    sizehints.width=sizehints.height=24;
    sizehints.min_width=sizehints.min_height=sizehints.max_width=sizehints.max_height=24;
    XSetNormalHints(m_display,m_traywindow,&sizehints);
    XSelectInput(m_display,m_traywindow,ButtonReleaseMask|ButtonPressMask|StructureNotifyMask);
}

void TrayIcon::Init(Display * display, Window window)
{
    assert(display);assert(window);
    m_window = window;
    m_display = display;
    vCreateTrayWindow();
    // Set Only_if_exists to False, The Atom will be created when needed. :-(
    _NET_SYSTEM_TRAY_OPCODE_Atom = XInternAtom(m_display,"_NET_SYSTEM_TRAY_OPCODE", False);
    char TraySn[32];
    sprintf(TraySn,"_NET_SYSTEM_TRAY_S%d",DefaultScreen(m_display));
    _NET_SYSTEM_TRAY_Sn_Atom = XInternAtom(m_display, TraySn, False);
    MANAGER_Atom = XInternAtom(m_display, "MANAGER", False);
    _NET_SYSTEM_TRAY_MESSAGE_DATA_Atom = XInternAtom(m_display,"_NET_SYSTEM_TRAY_MESSAGE_DATA", False);
    KWM_DOCKWINDOW_Atom = XInternAtom(m_display,"KWM_DOCKWINDOW",True);
    _KDE_NET_SYSTEM_TRAY_WINDOW_FOR_Atom = XInternAtom(m_display,"_KDE_NET_WM_SYSTEM_TRAY_WINDOW_FOR", True);
    TRAYICON_MESSAGE_TYPE_Atom = XInternAtom(m_display,TRAYICON_MESSAGE_TYPE, False);
}

bool TrayIcon::SendTrayMessage(long MessageType,long x,long y)
{
    XEvent ev;
    memset(&ev, 0, sizeof(ev));
    ev.xclient.type = ClientMessage;
    ev.xclient.window = m_window;
    ev.xclient.message_type = TRAYICON_MESSAGE_TYPE_Atom;
    ev.xclient.format = 32;
    ev.xclient.data.l[0] = MessageType;
    ev.xclient.data.l[1] = x;
    ev.xclient.data.l[2] = y;
    if ( XSendEvent(m_display, m_window, False, NoEventMask, &ev) )
        return true;
    return false;
}

bool TrayIcon::Install(Pixmap icon, Pixmap iconmask, const char * name)
{
    if ( name && strlen(name) )
        XChangeProperty(m_display,m_traywindow,
            XInternAtom(m_display,"_NET_WM_NAME", False),
            XInternAtom(m_display,"UTF8_STRING", False),
            8,
            PropModeReplace,
            (unsigned char *)name,
            strlen(name));
    
    if ( SysTrayPresent() )
    {
#ifndef NDEBUG        
        printf("Standard System Tray Present\n");
#endif
        XEvent ev;
        memset(&ev, 0, sizeof(ev));
        ev.xclient.type = ClientMessage;
        ev.xclient.window = m_systraywindow;
        ev.xclient.message_type = _NET_SYSTEM_TRAY_OPCODE_Atom;
        ev.xclient.format = 32;
        ev.xclient.data.l[0] = CurrentTime;
        ev.xclient.data.l[1] = SYSTEM_TRAY_REQUEST_DOCK;
        ev.xclient.data.l[2] = m_traywindow;

        if ( XSendEvent(m_display, m_systraywindow, False, NoEventMask, &ev) )
        {
            m_traystyle = StandardSpec;
            UpdateIcon(icon,iconmask);
            XSelectInput(m_display, m_systraywindow, StructureNotifyMask);  // wait for systray died
            return true;
        }
    }
    else if ( is_kde_wm() )
    {
        if ( _KDE_NET_SYSTEM_TRAY_WINDOW_FOR_Atom )
            XChangeProperty( m_display, m_traywindow, _KDE_NET_SYSTEM_TRAY_WINDOW_FOR_Atom, XA_WINDOW, 32,
     	   	    PropModeReplace, (unsigned char *)&m_window, 1);
        if ( KWM_DOCKWINDOW_Atom )
            XChangeProperty( m_display, m_traywindow, KWM_DOCKWINDOW_Atom, KWM_DOCKWINDOW_Atom, 32, 
                PropModeReplace, (unsigned char *)&m_window, 1);
        m_traystyle = KDE;
        UpdateIcon(icon,iconmask);
        XMapWindow(m_display,m_traywindow);
        return true;
    }
    XSelectInput(m_display,DefaultRootWindow(m_display), StructureNotifyMask);  // wait for systray added
    return false;
}

void TrayIcon::UpdateIcon(Pixmap icon, Pixmap iconmask)
{
    assert(m_display);
    assert(m_traywindow);
    if (!m_display || !m_traywindow)
        return;
    if (m_traystyle!=NotValid)
    {
        if (icon!=XmUNSPECIFIED_PIXMAP)
            XSetWindowBackgroundPixmap(m_display,m_traywindow,icon);
        if (iconmask!=XmUNSPECIFIED_PIXMAP)
            XShapeCombineMask(m_display,m_traywindow,ShapeBounding,0,0,iconmask,ShapeSet);
        XClearWindow(m_display,m_traywindow);
    }
}

bool TrayIcon::is_kde_wm(void)
{
    Atom type_r, iskde;
    int format_r;
    unsigned long nitems_r, bytesafter_r;
    unsigned char * prop_r;
    if ( !KWM_DOCKWINDOW_Atom && !_KDE_NET_SYSTEM_TRAY_WINDOW_FOR_Atom )
        return false;
    iskde = XInternAtom(m_display,"KWIN_RUNNING", True);
    if (iskde == None)
        return false;
    if ( XGetWindowProperty(
            m_display,
            DefaultRootWindow(m_display),
            iskde,
            0L,
            1L,
            False,
            AnyPropertyType,//iskde,
            &type_r,
            &format_r,
            &nitems_r,
            &bytesafter_r,
            &prop_r) == Success )
    {
        XFree(prop_r);
        if ( nitems_r > 0 && type_r == iskde)
        {
#ifndef NDEBUG
            printf("KWIN Running\n");
#endif
            return true;
        }
    }
    return false;
}

bool TrayIcon::SysTrayPresent(void)
{
    if ( _NET_SYSTEM_TRAY_Sn_Atom == None )
        return false;
    if ( (m_systraywindow=XGetSelectionOwner(m_display,_NET_SYSTEM_TRAY_Sn_Atom)) )
        return true;
    return false;
}

bool TrayIcon::bSendBalloonMessage(const char * message, int timeout)
{
    static long ID = 0;
    int len;
    assert( message && strlen(message) );
    assert( timeout >= 0 );
    if ( !message || !(len=strlen(message)) || timeout<0 || m_traystyle!=StandardSpec )
        return false;
    ID++;
    XEvent ev;
    memset(&ev, 0, sizeof(ev));
    ev.xclient.type = ClientMessage;
    //ev.xclient.window = m_systraywindow;
    ev.xclient.window = m_traywindow; // should be this one!
    ev.xclient.message_type = _NET_SYSTEM_TRAY_OPCODE_Atom;
    ev.xclient.format = 32;
    ev.xclient.data.l[0] = CurrentTime;
    ev.xclient.data.l[1] = SYSTEM_TRAY_BEGIN_MESSAGE;
    ev.xclient.data.l[2] = timeout;
    ev.xclient.data.l[3] = strlen(message);
    ev.xclient.data.l[4] = ID;

    if ( XSendEvent(m_display, m_systraywindow, False, StructureNotifyMask, &ev) )
    {
        XSync(m_display, False);
        const char * sendmessage = message;
        memset(&ev, 0, sizeof(ev));
        ev.xclient.type = ClientMessage;
        //ev.xclient.window = m_systraywindow;
        ev.xclient.window = m_traywindow; // should be this one!
        ev.xclient.message_type = _NET_SYSTEM_TRAY_MESSAGE_DATA_Atom;
        ev.xclient.format = 8;
        do
        {
            memcpy(ev.xclient.data.b, sendmessage, len>=20?20:len );
            if ( !XSendEvent(m_display, m_systraywindow, False, StructureNotifyMask, &ev) )
                return false;
            sendmessage += 20;
            len -= 20;
            XSync(m_display, False);
        } while( len>0 );
#ifndef NDEBUG
        printf("Tray Message Sent: %s\n",message);
#endif
        return true;
    }
    return false;
}

bool TrayIcon::bEventFilter(XEvent * pEvent)
{
    if ( pEvent->xany.window == m_traywindow )      // from me
    {
        if ( pEvent->xany.type==ButtonPress || pEvent->xany.type==ButtonRelease )
        {
            XWindowAttributes attr;
            if ( !XGetWindowAttributes( m_display, m_traywindow, &attr ) )
                return false;
            if ( pEvent->xbutton.x<0 || pEvent->xbutton.y<0 || pEvent->xbutton.x>attr.width || pEvent->xbutton.y>attr.height )
                return true;
            if ( pEvent->xbutton.type==ButtonPress && pEvent->xbutton.button==Button1 )
                SendTrayMessage(TRAYICON_LBUTTON,0,0);
            if ( pEvent->xbutton.type==ButtonRelease && pEvent->xbutton.button==Button3 )
                SendTrayMessage(TRAYICON_RBUTTON,pEvent->xbutton.x_root,pEvent->xbutton.y_root);
            return true;
        }   // Button
        else if ( pEvent->xany.type == ReparentNotify  )
        {
            if ( pEvent->xreparent.parent == DefaultRootWindow(m_display) )
                SendTrayMessage(TRAYICON_UNDOCKED,0,0);
            else if ( m_traystyle != NotValid )
            {
                const char * name = "Test";
                if ( name && strlen(name) )
                    XChangeProperty(m_display,m_traywindow,
                        XInternAtom(m_display,"_NET_WM_NAME", False),
                        XInternAtom(m_display,"UTF8_STRING", False),
                        8,
                        PropModeReplace,
                        (unsigned char *)name,
                        strlen(name));
                SendTrayMessage(TRAYICON_DOCKED,m_traystyle==StandardSpec,0);
            }
            else
            {
                XWithdrawWindow(m_display,m_traywindow,DefaultScreen(m_display));
                assert(0);
            }
            return true;
        }   // Reparent
        else if ( pEvent->xany.type == UnmapNotify )
        {
            if ( m_traystyle == StandardSpec )
            {
#ifndef NDEBUG
                printf("Warning, Standard System Tray exit\n");
#endif
                vCreateTrayWindow();    // Recreate it, Else the application will be destroyed :(
                SendTrayMessage(TRAYICON_UNDOCKED,0,0);
                XSelectInput(m_display,DefaultRootWindow(m_display), StructureNotifyMask);
                m_traystyle = NotValid; // Prevent to react with destroy notify.
            }
            else if ( m_traystyle == KDE )
            {
#ifndef NDEBUG
                printf("Warning, KDE System Tray exit\n");
#endif
            }
            return true;
        }   // Unmap
    }   // message is from my window
    else 
    // data.l[0] = time;
    // data.l[1] = Atom of _NET_SYSTEM_TRAY_Sn
    // data.l[2] = new systray window
    if ( pEvent->xany.type==ClientMessage
         && pEvent->xclient.window==DefaultRootWindow(m_display)
         && (Atom)pEvent->xclient.message_type==MANAGER_Atom
         && (Atom)pEvent->xclient.data.l[1]==_NET_SYSTEM_TRAY_Sn_Atom   //don't filter KDE
         && SysTrayPresent() )
    {
        assert((Window)pEvent->xclient.data.l[2]==m_systraywindow);
        SendTrayMessage(TRAYICON_PRESENT,0,0);
        return true;
    }
    else if ( pEvent->xany.window==m_systraywindow
              && pEvent->xany.type==DestroyNotify )
    {
        if ( m_traystyle == StandardSpec )
        {
#ifndef NDEBUG
            printf("Warning, Standard System Tray died\n");
#endif
            m_traywindow = 0;  // already destroyed now, by systraywindow?
            vCreateTrayWindow();
            SendTrayMessage(TRAYICON_UNDOCKED,0,0);
            XSelectInput(m_display,DefaultRootWindow(m_display), StructureNotifyMask);
        }
        else if ( m_traystyle == KDE )
        {
#ifndef NDEBUG
            printf("Warning, KDE System Tray died\n");
#endif
        }
        XSelectInput(m_display, m_systraywindow, 0);
        return true;
    }
    return false;
}

// end of file trayicon.cc
